/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.tomcatjdbc;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.text.StringTemplates;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.factory.tomcatjdbc.TomcatJdbcDataSources;
import java.util.Properties;
import javax.sql.DataSource;

@Name(value="tomcat")
@OnClasses(value={"org.apache.tomcat.jdbc.pool.DataSource", "org.apache.tomcat.jdbc.pool.DataSourceFactory"})
public class TomcatJdbcDataSourceFactory
implements DataSourceFactory {
    @Override
    public NamedDataSource get(DataSourceProperties dataSourceProperties) {
        if (DataSources.isImplementationKeyMatched("tomcat", dataSourceProperties)) {
            DataSource dataSource = TomcatJdbcDataSources.createDataSource(dataSourceProperties);
            String name = dataSourceProperties.getName();
            return DataSources.toNamedDataSource(dataSource, name);
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource implementationKey {}, expected key is {}", (Object[])new Object[]{dataSourceProperties.getImplementation(), "tomcat"}));
    }

    @Override
    public NamedDataSource get(Properties properties) {
        DataSource dataSource = TomcatJdbcDataSources.createDataSource(properties);
        String name = properties.getProperty("datasource.name");
        return DataSources.toNamedDataSource(dataSource, name);
    }
}

