/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.key;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.cluster.loadbalance.Node;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Strings;
import com.jn.langx.util.hash.HashCodeBuilder;

public class DataSourceKey
implements Node {
    @NonNull
    private String group = "primary";
    @NonNull
    private String name;

    public DataSourceKey() {
    }

    public DataSourceKey(String group, String name) {
        this.setGroup(group);
        this.setName(name);
    }

    public boolean isAvailable() {
        return Strings.isNotBlank((String)this.group) && Strings.isNotBlank((String)this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceKey that = (DataSourceKey)o;
        return this.group.equals(that.group) && this.name.equals(that.name);
    }

    public int hashCode() {
        return new HashCodeBuilder().with((Object)this.group).with((Object)this.name).build();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        if (Strings.isNotBlank((String)group)) {
            this.group = group;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (Strings.isNotBlank((String)name)) {
            this.name = name;
        }
    }

    public String toString() {
        return StringTemplates.formatWithPlaceholder((String)"group: {}, name: {}", (Object[])new Object[]{this.group, this.name});
    }

    public String getId() {
        return this.group + "," + this.name;
    }
}

