/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.key;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.annotation.Singleton;
import com.jn.langx.cluster.loadbalance.LoadBalancer;
import com.jn.langx.invocation.MethodInvocation;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.multivalue.CommonMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.collection.stack.ListableStack;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.ThreadLocalHolder;
import com.jn.sqlhelper.datasource.DataSourceRegistry;
import com.jn.sqlhelper.datasource.DataSourceRegistryAware;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.MethodDataSourceKeyRegistry;
import com.jn.sqlhelper.datasource.key.router.DataSourceKeyRouter;
import com.jn.sqlhelper.datasource.key.router.RandomRouter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DataSourceKeySelector
implements DataSourceRegistryAware,
LoadBalancer<DataSourceKey, MethodInvocation> {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceKeySelector.class);
    private static final ThreadLocalHolder<ListableStack<DataSourceKey>> DATA_SOURCE_KEY_HOLDER = new ThreadLocalHolder((Supplier0)new Supplier0<ListableStack<DataSourceKey>>(){

        public ListableStack<DataSourceKey> get() {
            return new ListableStack();
        }
    });
    private static final ThreadLocalHolder<DataSourceKey> CURRENT_SELECTED = new ThreadLocalHolder();
    @NonNull
    private MethodDataSourceKeyRegistry dataSourceKeyRegistry;
    @NonNull
    private DataSourceRegistry dataSourceRegistry;
    private DataSourceKeyRouter defaultRouter;
    private ConcurrentHashMap<String, DataSourceKeyRouter> routerMap = new ConcurrentHashMap();
    private MultiValueMap<String, String> groupToRoutersMap = new CommonMultiValueMap(new ConcurrentHashMap(), (Supplier)new Supplier<String, Collection<String>>(){

        public Collection<String> get(String group) {
            return Collects.newArrayList((Object[])new String[0]);
        }
    });

    public DataSourceKeySelector() {
        RandomRouter r = new RandomRouter();
        r.setLoadBalancer(this);
        this.registerRouter(r, true);
    }

    @Override
    public void setDataSourceRegistry(DataSourceRegistry registry) {
        this.dataSourceRegistry = registry;
        this.dataSourceRegistry.setLoadBalancer(this);
    }

    public MethodDataSourceKeyRegistry getDataSourceKeyRegistry() {
        return this.dataSourceKeyRegistry;
    }

    public void setDataSourceKeyRegistry(MethodDataSourceKeyRegistry dataSourceKeyRegistry) {
        this.dataSourceKeyRegistry = dataSourceKeyRegistry;
    }

    public void setDefaultRouter(DataSourceKeyRouter router) {
        this.defaultRouter = router;
    }

    public void registerRouter(DataSourceKeyRouter router) {
        this.registerRouter(router, false);
    }

    public void registerRouter(DataSourceKeyRouter router, boolean asDefault) {
        Preconditions.checkNotNull((Object)router);
        Preconditions.checkNotEmpty((Object)router.getName(), (String)"the router name is null or empty");
        this.routerMap.put(router.getName(), router);
        router.setLoadBalancer(this);
        if (asDefault) {
            this.setDefaultRouter(router);
        }
    }

    public void registerRouters(List<DataSourceKeyRouter> routers) {
        Collects.forEach(routers, (Consumer)new Consumer<DataSourceKeyRouter>(){

            public void accept(DataSourceKeyRouter router) {
                DataSourceKeySelector.this.registerRouter(router);
            }
        });
    }

    public void allocateRouters(final String group, Collection<String> routerNames) {
        Collects.forEach(routerNames, (Consumer)new Consumer<String>(){

            public void accept(String routerName) {
                DataSourceKeySelector.this.groupToRoutersMap.addIfAbsent((Object)group, (Object)routerName);
            }
        });
    }

    public List<DataSourceKeyRouter> getRouters(String group) {
        return Pipeline.of((Iterable)((Iterable)this.groupToRoutersMap.get((Object)group))).map((Function)new Function<String, DataSourceKeyRouter>(){

            public DataSourceKeyRouter apply(String routerName) {
                return (DataSourceKeyRouter)DataSourceKeySelector.this.routerMap.get(routerName);
            }
        }).clearNulls().asList();
    }

    public static void addChoice(DataSourceKey key) {
        Preconditions.checkNotNull((Object)key);
        ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
        stack.push((Object)key);
    }

    public static void removeChoice(@Nullable DataSourceKey key) {
        ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
        if (!stack.isEmpty()) {
            if (key != null) {
                if (key == stack.peek()) {
                    stack.pop();
                } else {
                    logger.warn("the datasource key {} will been removed is not equals the stack top :{}", (Object)key, stack.peek());
                }
            } else {
                stack.pop();
            }
        }
    }

    public static ListableStack<DataSourceKey> getChoices() {
        return (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
    }

    public static void clearChoices() {
        ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
        stack.clear();
    }

    public static void setCurrent(DataSourceKey key) {
        Preconditions.checkNotNull((Object)key);
        CURRENT_SELECTED.set((Object)key);
        DataSourceKeySelector.addChoice(key);
    }

    public static DataSourceKey getCurrent() {
        return (DataSourceKey)CURRENT_SELECTED.get();
    }

    public static void removeCurrent() {
        DataSourceKey current = DataSourceKeySelector.getCurrent();
        CURRENT_SELECTED.reset();
        DataSourceKeySelector.removeChoice(current);
    }

    public final DataSourceKey select(@Nullable MethodInvocation methodInvocation) {
        NamedDataSource dataSource;
        DataSourceKey key = null;
        if (methodInvocation != null) {
            key = this.dataSourceKeyRegistry.get((Method)methodInvocation.getJoinPoint());
        }
        if (key != null && (dataSource = this.dataSourceRegistry.get(key)) != null) {
            DataSourceKeySelector.setCurrent(key);
        }
        if ((key = DataSourceKeySelector.getCurrent()) == null && (key = this.doSelect(methodInvocation)) != null) {
            DataSourceKeySelector.setCurrent(key);
        }
        if (key != null && (dataSource = this.dataSourceRegistry.get(key)) == null) {
            logger.warn("Can't find a datasource named: {}", (Object)key);
        }
        return key;
    }

    protected DataSourceKey doSelect(final @Nullable MethodInvocation methodInvocation) {
        if (!CURRENT_SELECTED.isNull()) {
            return DataSourceKeySelector.getCurrent();
        }
        Preconditions.checkArgument((this.dataSourceRegistry.size() > 0 ? 1 : 0) != 0, (String)"has no any datasource registered");
        if (this.dataSourceRegistry.size() == 1) {
            return this.dataSourceRegistry.getPrimary();
        }
        final Holder dataSourceKeyList = new Holder();
        if (dataSourceKeyList.isEmpty()) {
            ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
            if (Emptys.isEmpty((Object)stack)) {
                List<DataSourceKey> matched = this.dataSourceRegistry.findKeys(this.dataSourceRegistry.getPrimary());
                if (Emptys.isNotEmpty(matched)) {
                    dataSourceKeyList.set(matched);
                }
            } else {
                Collects.forEach((Iterable)stack, (Predicate)new Predicate<DataSourceKey>(){

                    public boolean test(DataSourceKey dataSourceKey) {
                        return dataSourceKey != null;
                    }
                }, (Consumer)new Consumer<DataSourceKey>(){

                    public void accept(DataSourceKey dataSourceKey) {
                        List<DataSourceKey> matched = DataSourceKeySelector.this.dataSourceRegistry.findKeys(dataSourceKey);
                        if (Emptys.isNotEmpty(matched)) {
                            dataSourceKeyList.set(matched);
                        }
                    }
                }, (Predicate)new Predicate<DataSourceKey>(){

                    public boolean test(DataSourceKey dataSourceKey) {
                        return !dataSourceKeyList.isEmpty();
                    }
                });
            }
        }
        if (!dataSourceKeyList.isEmpty()) {
            final List keys = (List)dataSourceKeyList.get();
            if (keys.size() == 1) {
                return (DataSourceKey)keys.get(0);
            }
            final Holder keyHolder = new Holder();
            List routers = this.getRouters(((DataSourceKey)keys.get(0)).getGroup());
            if (Emptys.isEmpty(routers) && this.defaultRouter != null) {
                routers = Collects.asList((Object[])new DataSourceKeyRouter[]{this.defaultRouter});
            }
            Collects.forEach((Iterable)routers, (Consumer)new Consumer<DataSourceKeyRouter>(){

                public void accept(DataSourceKeyRouter groupRouter) {
                    keyHolder.set((Object)groupRouter.select(keys, methodInvocation));
                }
            }, (Predicate)new Predicate<DataSourceKeyRouter>(){

                public boolean test(DataSourceKeyRouter groupRouter) {
                    return !keyHolder.isNull();
                }
            });
            return (DataSourceKey)keyHolder.get();
        }
        return null;
    }

    public DataSourceRegistry getDataSourceRegistry() {
        return this.dataSourceRegistry;
    }

    public void addNode(DataSourceKey node) {
    }

    public void removeNode(DataSourceKey key) {
    }

    public boolean hasNode(DataSourceKey key) {
        return this.dataSourceRegistry.get(key) != null;
    }

    public void markDown(DataSourceKey key) {
    }

    public List<DataSourceKey> getNodes() {
        return this.dataSourceRegistry.allKeys();
    }

    public List<DataSourceKey> getNodes(Predicate<DataSourceKey> predicate) {
        return Pipeline.of(this.getNodes()).filter(predicate).asList();
    }

    public boolean isEmpty() {
        return this.dataSourceRegistry.size() == 0;
    }
}

