/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.key;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.registry.Registry;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.struct.Holder;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.parser.DataSourceAnnotationParser;
import com.jn.sqlhelper.datasource.key.parser.DataSourceKeyAnnotationParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodDataSourceKeyRegistry
implements Registry<Method, DataSourceKey> {
    private final ConcurrentHashMap<Method, Holder<DataSourceKey>> methodDataSourceKeyCache = new ConcurrentHashMap();
    private Map<Class<? extends Annotation>, DataSourceKeyAnnotationParser> annotationParserMap = new LinkedHashMap<Class<? extends Annotation>, DataSourceKeyAnnotationParser>();

    public MethodDataSourceKeyRegistry() {
        this.registerDataSourceKeyParser(new DataSourceAnnotationParser());
    }

    public void register(DataSourceKey dataSourceKeyHolder) {
        throw new UnsupportedOperationException();
    }

    public void register(Method method, DataSourceKey dataSourceKey) {
        Preconditions.checkNotNull((Object)dataSourceKey);
        this.methodDataSourceKeyCache.putIfAbsent(method, (Holder<DataSourceKey>)new Holder((Object)dataSourceKey));
    }

    public void registerDataSourceKeyParser(DataSourceKeyAnnotationParser dataSourceKeyAnnotationParser) {
        if (dataSourceKeyAnnotationParser != null && dataSourceKeyAnnotationParser.getAnnotation() != null) {
            this.annotationParserMap.put(dataSourceKeyAnnotationParser.getAnnotation(), dataSourceKeyAnnotationParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public DataSourceKey get(final Method method) {
        Holder<DataSourceKey> holder = this.methodDataSourceKeyCache.get(method);
        if (holder == null) {
            MethodDataSourceKeyRegistry methodDataSourceKeyRegistry = this;
            synchronized (methodDataSourceKeyRegistry) {
                final Holder holder0 = new Holder();
                Collects.forEach(this.annotationParserMap, (Consumer2)new Consumer2<Class<? extends Annotation>, DataSourceKeyAnnotationParser>(){

                    public void accept(Class<? extends Annotation> annotationClass, DataSourceKeyAnnotationParser parser) {
                        DataSourceKey key = parser.parse(method);
                        if (key != null) {
                            holder0.set((Object)key);
                        }
                    }
                }, (Predicate2)new Predicate2<Class<? extends Annotation>, DataSourceKeyAnnotationParser>(){

                    public boolean test(Class<? extends Annotation> key, DataSourceKeyAnnotationParser value) {
                        return !holder0.isNull();
                    }
                });
                this.methodDataSourceKeyCache.putIfAbsent(method, (Holder<DataSourceKey>)holder0);
                holder = this.methodDataSourceKeyCache.get(method);
            }
        }
        return (DataSourceKey)holder.get();
    }
}

