/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.IOs;
import com.jn.sqlhelper.common.utils.Connections;
import com.jn.sqlhelper.datasource.DataSourceRegistry;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.jn.sqlhelper.datasource.definition.DataSourcesProperties;
import com.jn.sqlhelper.datasource.factory.CentralizedDataSourceFactory;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.DataSourceKeySelector;
import com.jn.sqlhelper.datasource.key.MethodDataSourceKeyRegistry;
import com.jn.sqlhelper.datasource.key.parser.DataSourceKeyAnnotationParser;
import com.jn.sqlhelper.datasource.key.parser.DataSourceKeyDataSourceParser;
import com.jn.sqlhelper.datasource.key.router.DataSourceKeyRouter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(name={"sqlhelper.dynamicDataSource.enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
public class DynamicDataSourcesAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourcesAutoConfiguration.class);

    @Bean
    public DataSourceRegistry dataSourceRegistry(ObjectProvider<DataSourceKeyDataSourceParser> dataSourceKeyParserProvider) {
        DataSourceRegistry dataSourceRegistry = new DataSourceRegistry();
        DataSourceKeyDataSourceParser dataSourceKeyParser = (DataSourceKeyDataSourceParser)dataSourceKeyParserProvider.getIfAvailable();
        dataSourceRegistry.setKeyParser(dataSourceKeyParser);
        return dataSourceRegistry;
    }

    @Bean
    public CentralizedDataSourceFactory centralizedDataSourceFactory(DataSourceRegistry dataSourceRegistry) {
        CentralizedDataSourceFactory factory = new CentralizedDataSourceFactory();
        factory.setRegistry(dataSourceRegistry);
        return factory;
    }

    @Bean
    @ConfigurationProperties(prefix="sqlhelper.dynamicDataSource")
    public DataSourcesProperties namedDataSourcesProperties(Environment environment) {
        String requiredClass;
        String keyChoicesPointcutExpression = environment.getProperty("sqlhelper.dynamicDataSource.key-choices-pointcut.expression");
        if (Strings.isNotBlank((String)keyChoicesPointcutExpression) && !ClassLoaders.hasClass((String)(requiredClass = "com.jn.agileway.spring.aop.AspectJExpressionPointcutAdvisorProperties"), (ClassLoader)this.getClass().getClassLoader())) {
            StringBuilder log = new StringBuilder("The configuration property 'sqlhelper.dynamicDataSource.key-choices-pointcut.expression' has specified, but can't find the class: 'com.jn.agileway.spring.aop.AspectJExpressionPointcutAdvisorProperties', you should import the following jars to your classpath:\n").append("\t1) com.github.fangjinuo.agilway:agileway-spring:${agileway.version}.jar\n").append("\t2) org.springframework:spring-aop:${spring.version}.jar\n").append("\t3) org.aspectj:aspectjweaver:${aspectj.version}.jar\n");
            logger.warn(log.toString());
        }
        return new DataSourcesProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bean(name={"dataSourcesFactoryBean"})
    public ListFactoryBean dataSourcesFactoryBean(final CentralizedDataSourceFactory centralizedDataSourceFactory, DataSourcesProperties namedDataSourcesProperties, ObjectProvider<DataSource> springBootOriginDataSourceProvider) {
        logger.info("===[SQLHelper & Dynamic DataSource]=== the dynamic datasource is enabled");
        List<DataSourceProperties> dataSourcePropertiesList = namedDataSourcesProperties.getDataSources();
        List dataSources = Pipeline.of(dataSourcePropertiesList).map((Function)new Function<DataSourceProperties, NamedDataSource>(){

            public NamedDataSource apply(DataSourceProperties dataSourceProperties) {
                return centralizedDataSourceFactory.get(dataSourceProperties);
            }
        }).clearNulls().asList();
        DataSource springBootOriginDataSource = (DataSource)springBootOriginDataSourceProvider.getIfAvailable();
        if (springBootOriginDataSource != null) {
            Connection conn = null;
            try {
                conn = springBootOriginDataSource.getConnection();
            }
            catch (Throwable ex) {
                logger.error("Can't connect the spring boot jdbc datasource, error: {}", (Object)ex.getMessage(), (Object)ex);
            }
            boolean isTestDB = true;
            if (conn != null) {
                try {
                    String catalog = Connections.getCatalog((Connection)conn);
                    String schema = Connections.getSchema((Connection)conn);
                    if (!Strings.equalsIgnoreCase((CharSequence)"testdb", (CharSequence)catalog) && !Strings.equalsIgnoreCase((CharSequence)"testdb", (CharSequence)schema)) {
                        isTestDB = false;
                    }
                }
                catch (Throwable catalog) {
                }
                finally {
                    IOs.close((Object)conn);
                }
            }
            if (!isTestDB) {
                NamedDataSource namedDataSource = DataSources.toNamedDataSource(springBootOriginDataSource);
                if (dataSources.isEmpty()) {
                    namedDataSource.setName("primary");
                }
                centralizedDataSourceFactory.getRegistry().register(namedDataSource);
                dataSources.add(namedDataSource);
            }
        }
        if (logger.isInfoEnabled() && !dataSources.isEmpty()) {
            StringBuilder log = new StringBuilder(256);
            log.append("===[SQLHelper & Dynamic DataSource]=== will load dataSources:\n\t");
            Collection keys = Collects.map((Object)dataSources, (Function)new Function<NamedDataSource, DataSourceKey>(){

                public DataSourceKey apply(NamedDataSource namedDataSource) {
                    return namedDataSource.getDataSourceKey();
                }
            });
            log.append(Strings.join((String)"\n\t", (Iterable)keys));
            logger.info(log.toString());
        }
        ListFactoryBean dataSourcesFactoryBean = new ListFactoryBean();
        dataSourcesFactoryBean.setTargetListClass(ArrayList.class);
        dataSourcesFactoryBean.setSourceList(dataSources);
        return dataSourcesFactoryBean;
    }

    @Bean
    public MethodDataSourceKeyRegistry dataSourceKeyRegistry(ObjectProvider<List<DataSourceKeyAnnotationParser>> dataSourceKeyAnnotationParsersProvider) {
        final MethodDataSourceKeyRegistry registry = new MethodDataSourceKeyRegistry();
        List parsers = (List)dataSourceKeyAnnotationParsersProvider.getIfAvailable();
        Collects.forEach((Iterable)parsers, (Consumer)new Consumer<DataSourceKeyAnnotationParser>(){

            public void accept(DataSourceKeyAnnotationParser dataSourceKeyAnnotationParser) {
                registry.registerDataSourceKeyParser(dataSourceKeyAnnotationParser);
            }
        });
        return registry;
    }

    @Bean
    public DataSourceKeySelector dataSourceKeySelector(DataSourceRegistry registry, MethodDataSourceKeyRegistry keyRegistry, ObjectProvider<List<DataSourceKeyRouter>> routersProvider, DataSourcesProperties dataSourcesProperties) {
        DataSourceKeyRouter defaultRouter;
        final DataSourceKeySelector selector = new DataSourceKeySelector();
        selector.setDataSourceKeyRegistry(keyRegistry);
        selector.setDataSourceRegistry(registry);
        List routers = (List)routersProvider.getIfAvailable();
        selector.registerRouters(routers);
        final String defaultRouterName = dataSourcesProperties.getDefaultRouter();
        if (Emptys.isNotEmpty((Object)defaultRouterName) && (defaultRouter = (DataSourceKeyRouter)Collects.findFirst((Collection)routers, (Predicate)new Predicate<DataSourceKeyRouter>(){

            public boolean test(DataSourceKeyRouter dataSourceKeyRouter) {
                return defaultRouterName.equals(dataSourceKeyRouter.getName());
            }
        })) != null) {
            selector.setDefaultRouter(defaultRouter);
        }
        MultiValueMap<String, String> groupToRoutersMap = dataSourcesProperties.getGroupRouters();
        Collects.forEach(groupToRoutersMap, (Consumer2)new Consumer2<String, Collection<String>>(){

            public void accept(String group, Collection<String> routers) {
                selector.allocateRouters(group, routers);
            }
        });
        return selector;
    }
}

