/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.agileway.spring.aop.AspectJExpressionPointcutAdvisorBuilder;
import com.jn.agileway.spring.aop.AspectJExpressionPointcutAdvisorProperties;
import com.jn.sqlhelper.datasource.key.MethodDataSourceKeyRegistry;
import com.jn.sqlhelper.datasource.spring.aop.DataSourceKeyChoicesAnnotationMethodInterceptor;
import org.aopalliance.intercept.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"sqlhelper.dynamicDataSource.enabled"}, havingValue="true")
@ConditionalOnClass(value={AspectJExpressionPointcutAdvisorProperties.class})
public class DynamicMethodDataSourcesKeyAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMethodDataSourcesKeyAutoConfiguration.class);

    @Bean(value={"aspectJExpressionPointcutAdvisorProperties"})
    @ConfigurationProperties(prefix="sqlhelper.dynamicDataSource.key-choices-pointcut")
    public AspectJExpressionPointcutAdvisorProperties aspectJExpressionPointcutAdvisorProperties() {
        return new AspectJExpressionPointcutAdvisorProperties();
    }

    @Bean
    @ConditionalOnProperty(prefix="sqlhelper.dynamicDataSource.key-choices-pointcut", name={"expression"})
    public DataSourceKeyChoicesAnnotationMethodInterceptor interceptor(MethodDataSourceKeyRegistry keyRegistry) {
        DataSourceKeyChoicesAnnotationMethodInterceptor interceptor = new DataSourceKeyChoicesAnnotationMethodInterceptor();
        interceptor.setKeyRegistry(keyRegistry);
        return interceptor;
    }

    @Bean(value={"annotationKeyChoicesAdvisor"})
    @ConditionalOnProperty(prefix="sqlhelper.dynamicDataSource.key-choices-pointcut", name={"expression"})
    @ConditionalOnMissingBean(name={"annotationKeyChoicesAdvisor"})
    public AspectJExpressionPointcutAdvisor keyChoicesAdvisor(AspectJExpressionPointcutAdvisorProperties properties, DataSourceKeyChoicesAnnotationMethodInterceptor interceptor) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisorBuilder().properties(properties).interceptor((Interceptor)interceptor).build();
        logger.info("===[SQLHelper]=== Add datasource key choices interceptor, use an expression: {}", (Object)properties.getExpression());
        return advisor;
    }
}

