/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.instrument;

import com.jn.langx.factory.Provider;
import com.jn.sqlhelper.dialect.instrument.SQLInstrumentorConfig;
import com.jn.sqlhelper.dialect.instrument.SQLStatementInstrumentor;
import java.util.IdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLInstrumentorProvider
implements Provider<SQLInstrumentorConfig, SQLStatementInstrumentor> {
    private static final Logger logger = LoggerFactory.getLogger(SQLInstrumentorProvider.class);
    private IdentityHashMap<SQLInstrumentorConfig, SQLStatementInstrumentor> instrumentCache = new IdentityHashMap();
    private static SQLInstrumentorProvider instance = new SQLInstrumentorProvider();

    private SQLInstrumentorProvider() {
        logger.info("Initial the singleton SQL instrumentor provider");
    }

    public static SQLInstrumentorProvider getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatementInstrumentor get(SQLInstrumentorConfig config) {
        SQLStatementInstrumentor instrumentor;
        if (config == null) {
            config = SQLInstrumentorConfig.DEFAULT;
        }
        if ((instrumentor = this.instrumentCache.get(config)) != null) {
            return instrumentor;
        }
        SQLInstrumentorProvider sQLInstrumentorProvider = this;
        synchronized (sQLInstrumentorProvider) {
            instrumentor = this.instrumentCache.get(config);
            if (instrumentor == null) {
                instrumentor = new SQLStatementInstrumentor();
                if (config == SQLInstrumentorConfig.DEFAULT) {
                    logger.warn("Initial the SQL instrument config use default value");
                }
                instrumentor.setConfig(config);
                instrumentor.init();
                this.instrumentCache.put(config, instrumentor);
            }
        }
        return instrumentor;
    }

    public SQLStatementInstrumentor get() {
        return this.get(null);
    }
}

