/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.annotation.Name;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;

@Name(value="maxdb")
public class MaxDBDialect
extends AbstractDialect {
    public MaxDBDialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection rowSelection) {
                boolean hasOffset = LimitHelper.hasFirstRow(rowSelection);
                return this.getLimitString(sql, hasOffset);
            }

            @Override
            protected String getLimitString(String sql, boolean hasOffset) {
                sql = "select * from (" + sql + ") where rowno < ? ";
                if (hasOffset) {
                    sql = sql + " and rowno >= ?";
                }
                return sql;
            }
        });
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return false;
    }
}

