/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.annotation.Name;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.sqlhelper.dialect.internal.AbstractTransactSQLDialect;
import com.jn.sqlhelper.dialect.internal.limit.OffsetFetchFirstOnlyLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.SQLServer2005LimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.TopLimitHandler;
import com.jn.sqlhelper.dialect.internal.urlparser.SqlServerUrlParser;
import com.jn.sqlhelper.dialect.likeescaper.BackslashStyleEscaper;

@Name(value="sqlserver")
public class SQLServerDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 2100;

    public SQLServerDialect() {
        this.setLikeEscaper(BackslashStyleEscaper.NON_DEFAULT_INSTANCE);
        this.setDelegate(new SQLServer2008Dialect());
        this.setUrlParser(new SqlServerUrlParser());
    }

    public static String guessDatabaseId(String productionVersion) {
        Preconditions.checkNotNull((Object)productionVersion);
        String[] segments = Strings.split((String)productionVersion, (String)".");
        if (segments.length > 0) {
            String majorVersionString = segments[0];
            int majorVersion = Integer.parseInt(majorVersionString);
            String databaseId = null;
            switch (majorVersion) {
                case 8: {
                    databaseId = "sqlserver2000";
                    break;
                }
                case 9: {
                    databaseId = "sqlserver2005";
                    break;
                }
                case 10: {
                    databaseId = "sqlserver2008";
                    break;
                }
                case 11: {
                    databaseId = "sqlserver2012";
                    break;
                }
                case 12: {
                    databaseId = "sqlserver2014";
                    break;
                }
                case 13: {
                    databaseId = "sqlserver2016";
                    break;
                }
                case 14: {
                    databaseId = "sqlserver2017";
                }
            }
            return databaseId;
        }
        return null;
    }

    @Override
    public boolean isBindLimitParametersFirst() {
        return false;
    }

    @Override
    public char getBeforeQuote() {
        return '[';
    }

    @Override
    public char getAfterQuote() {
        return ']';
    }

    @Name(value="sqlserver2017")
    public static class SQLServer2017Dialect
    extends SQLServer2016Dialect {
    }

    @Name(value="sqlserver2016")
    public static class SQLServer2016Dialect
    extends SQLServer2014Dialect {
    }

    @Name(value="sqlserver2014")
    public static class SQLServer2014Dialect
    extends SQLServer2012Dialect {
    }

    @Name(value="sqlserver2012")
    public static class SQLServer2012Dialect
    extends SQLServer2008Dialect {
        public SQLServer2012Dialect() {
            this.setLimitHandler(new OffsetFetchFirstOnlyLimitHandler().setSupportSimplifyFirstOnly(false));
        }

        @Override
        public boolean isBindLimitParametersInReverseOrder() {
            return false;
        }
    }

    @Name(value="sqlserver2008")
    public static class SQLServer2008Dialect
    extends SQLServer2005Dialect {
    }

    @Name(value="sqlserver2005")
    public static class SQLServer2005Dialect
    extends AbstractTransactSQLDialect {
        public SQLServer2005Dialect() {
            this.setLimitHandler(new SQLServer2005LimitHandler());
            this.setDelegate(null);
        }

        @Override
        public boolean isSupportsLimit() {
            return true;
        }

        @Override
        public boolean isUseMaxForLimit() {
            return true;
        }

        @Override
        public boolean isSupportsLimitOffset() {
            return true;
        }

        @Override
        public boolean isSupportsVariableLimit() {
            return true;
        }

        @Override
        public char getBeforeQuote() {
            return '[';
        }

        @Override
        public char getAfterQuote() {
            return ']';
        }
    }

    @Name(value="sqlserver2000")
    public static class SQLServer2000Dialect
    extends AbstractTransactSQLDialect {
        public SQLServer2000Dialect() {
            this.setLimitHandler(new TopLimitHandler());
            this.setDelegate(null);
        }

        @Override
        public boolean isSupportsLimit() {
            return true;
        }

        @Override
        public boolean isUseMaxForLimit() {
            return true;
        }

        @Override
        public boolean isSupportsLimitOffset() {
            return false;
        }

        @Override
        public boolean isSupportsVariableLimit() {
            return false;
        }

        @Override
        public boolean isBindLimitParametersFirst() {
            return true;
        }
    }
}

