/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class LimitOffsetLimitHandler
extends AbstractLimitHandler {
    private boolean hasOffsetRowsSuffix = false;
    private boolean supportForUpdate;
    private boolean supportLockInModeClause;

    @Override
    public String processSql(String sql, RowSelection rowSelection) {
        return this.getLimitString(sql, LimitHelper.getFirstRow(rowSelection), this.getMaxOrLimit(rowSelection));
    }

    @Override
    protected String getLimitString(String sql, long offset, int limit) {
        int lockInIndex;
        int forUpdateIndex;
        boolean hasOffset = offset > 0L;
        sql = sql.trim();
        String forUpdateClause = "";
        boolean isForUpdate = false;
        String sqlLowercase = sql.toLowerCase(Locale.ROOT);
        if (this.isSupportForUpdate() && (forUpdateIndex = sqlLowercase.lastIndexOf("for update")) > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        String lockInClause = "";
        boolean hasLockInClause = false;
        if (!isForUpdate && this.isSupportLockInModeClause() && (lockInIndex = sqlLowercase.lastIndexOf("lock in")) > -1) {
            lockInClause = sql.substring(lockInIndex);
            sql = sql.substring(0, lockInIndex - 1);
            hasLockInClause = true;
        }
        StringBuilder sql2 = new StringBuilder(sql.length() + 100);
        sql2.append(sql);
        if (this.getDialect().isUseLimitInVariableMode()) {
            if (hasOffset) {
                sql2.append(" limit ? offset ? " + (this.hasOffsetRowsSuffix ? "rows" : ""));
            } else {
                sql2.append(" limit ?");
            }
        } else if (hasOffset) {
            sql2.append(" limit " + limit + " offset " + offset + " " + (this.hasOffsetRowsSuffix ? "rows" : ""));
        } else {
            sql2.append(" limit " + limit);
        }
        if (isForUpdate) {
            sql2.append(" " + forUpdateClause);
        }
        if (hasLockInClause) {
            sql2.append(" " + lockInClause);
        }
        return sql2.toString();
    }

    public boolean isHasOffsetRowsSuffix() {
        return this.hasOffsetRowsSuffix;
    }

    public LimitOffsetLimitHandler setHasOffsetRowsSuffix(boolean hasOffsetRowsSuffix) {
        this.hasOffsetRowsSuffix = hasOffsetRowsSuffix;
        return this;
    }

    public boolean isSupportForUpdate() {
        return this.supportForUpdate;
    }

    public LimitOffsetLimitHandler setSupportForUpdate(boolean supportForUpdate) {
        this.supportForUpdate = supportForUpdate;
        return this;
    }

    public boolean isSupportLockInModeClause() {
        return this.supportLockInModeClause;
    }

    public LimitOffsetLimitHandler setSupportLockInModeClause(boolean supportLockInModeClause) {
        this.supportLockInModeClause = supportLockInModeClause;
        return this;
    }
}

