/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.StringMaker;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.internal.urlparser.DefaultDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UnKnownDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UrlParser;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUrlParser
implements UrlParser {
    private final Logger logger = LoggerFactory.getLogger(CommonUrlParser.class);
    private Dialect dialect;

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            this.logger.info("jdbcUrl may not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        List<String> urlPrefixes = this.getUrlSchemas();
        String matchedUrlPrefix = null;
        for (String urlPrefix : urlPrefixes) {
            if (!jdbcUrl.startsWith(urlPrefix)) continue;
            matchedUrlPrefix = urlPrefix;
        }
        if (matchedUrlPrefix == null) {
            this.logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)urlPrefixes.toString());
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl, matchedUrlPrefix);
        }
        catch (Exception e) {
            this.logger.info("{} parse error. url: {}, Caused: {}", new Object[]{this.getClass().getSimpleName(), jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase("dm", jdbcUrl);
        }
        return result;
    }

    protected DatabaseInfo parse0(String url, String urlPrefix) {
        StringMaker maker = new StringMaker(url);
        maker.after(urlPrefix);
        String host = maker.after("//").before('/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo(this.getDialect().getDatabaseId(), url, normalizedUrl, hostList, databaseId);
    }

    @Override
    public List<String> getUrlSchemas() {
        return Collections.emptyList();
    }
}

