/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.StringMaker;
import com.jn.sqlhelper.dialect.internal.urlparser.CommonUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.DefaultDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UnKnownDatabaseInfo;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubridUrlParser
extends CommonUrlParser {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 30000;
    public static final String DEFAULT_USER = "public";
    public static final String DEFAULT_PASSWORD = "";
    private static final String URL_PREFIX_PATTERN = "jdbc:cubrid(-oracle|-mysql)?:";
    private static final Pattern PREFIX_PATTERN;
    private static final String URL_PATTERN = "jdbc:cubrid(-oracle|-mysql)?:([a-zA-Z_0-9\\.-]*):([0-9]*):([^:]+):([^:]*):([^:]*):(\\?[a-zA-Z_0-9]+=[^&=?]+(&[a-zA-Z_0-9]+=[^&=?]+)*)?";
    private static final Pattern PATTERN;
    private static final Logger logger;
    private static final String URL_PREFIX = "jdbc:cubrid";
    private static final List<String> URL_SCHEMAS;

    @Override
    public List<String> getUrlSchemas() {
        return URL_SCHEMAS;
    }

    @Override
    public DatabaseInfo parse(String jdbcUrl) {
        Matcher matcher = PREFIX_PATTERN.matcher(jdbcUrl);
        if (!matcher.find()) {
            logger.info("jdbcUrl has invalid prefix.(url:{}, prefix-pattern:{})", (Object)jdbcUrl, (Object)URL_PREFIX_PATTERN);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            logger.info("CubridJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase("cubrid", jdbcUrl);
        }
        return result;
    }

    private DatabaseInfo parse0(String jdbcUrl) {
        Matcher matcher = PATTERN.matcher(jdbcUrl);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        String host = matcher.group(2);
        String portString = matcher.group(3);
        String db = matcher.group(4);
        String user = matcher.group(5);
        if (host == null || host.length() == 0) {
            host = DEFAULT_HOSTNAME;
        }
        if (user == null) {
            user = DEFAULT_USER;
        }
        StringMaker maker = new StringMaker(jdbcUrl);
        String normalizedUrl = maker.clear().before('?').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        String hostAndPort = host + ":" + portString;
        hostList.add(hostAndPort);
        return new DefaultDatabaseInfo("cubrid", jdbcUrl, normalizedUrl, hostList, db);
    }

    static {
        logger = LoggerFactory.getLogger(CubridUrlParser.class);
        URL_SCHEMAS = Arrays.asList(URL_PREFIX);
        PREFIX_PATTERN = Pattern.compile(URL_PREFIX_PATTERN, 2);
        PATTERN = Pattern.compile(URL_PATTERN, 2);
    }
}

