/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.List;

public class DefaultDatabaseInfo
implements DatabaseInfo {
    private final String databaseId;
    private final String realUrl;
    private final String normalizedUrl;
    private final List<String> host;
    private final String multipleHost;
    private final String verdor;
    private final boolean parsingComplete;

    public DefaultDatabaseInfo(String verdor, String realUrl, String normalizedUrl, List<String> host, String databaseId) {
        this(verdor, realUrl, normalizedUrl, host, databaseId, true);
    }

    public DefaultDatabaseInfo(String verdor, String realUrl, String normalizedUrl, List<String> host, String databaseId, boolean parsingComplete) {
        this.verdor = verdor;
        this.realUrl = realUrl;
        this.normalizedUrl = normalizedUrl;
        this.host = host;
        this.multipleHost = this.merge(host);
        this.databaseId = databaseId;
        this.parsingComplete = parsingComplete;
    }

    private String merge(List<String> host) {
        if (host.isEmpty()) {
            return "";
        }
        String single = host.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(single);
        for (int i = 1; i < host.size(); ++i) {
            sb.append(',');
            sb.append(host.get(i));
        }
        return sb.toString();
    }

    @Override
    public List<String> getHost() {
        return this.host;
    }

    @Override
    public String getMultipleHost() {
        return this.multipleHost;
    }

    @Override
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public String getRealUrl() {
        return this.realUrl;
    }

    @Override
    public String getUrl() {
        return this.normalizedUrl;
    }

    @Override
    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDatabaseInfo{");
        sb.append("verdor=").append(this.verdor);
        sb.append(", databaseId='").append(this.databaseId).append('\'');
        sb.append(", realUrl='").append(this.realUrl).append('\'');
        sb.append(", normalizedUrl='").append(this.normalizedUrl).append('\'');
        sb.append(", host=").append(this.host);
        sb.append(", multipleHost='").append(this.multipleHost).append('\'');
        sb.append(", parsingComplete=").append(this.parsingComplete);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getVendor() {
        return this.verdor;
    }
}

