/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser.oracle;

import com.jn.sqlhelper.dialect.internal.urlparser.oracle.Token;
import java.util.ArrayList;
import java.util.List;

public class OracleNetConnectionDescriptorTokenizer {
    public static final char TOKEN_EQUAL = '=';
    public static final char TOKEN_KEY_START = '(';
    public static final char TOKEN_KEY_END = ')';
    private static final char TOKEN_COMMA = ',';
    private static final char TOKEN_BKSLASH = '\\';
    private static final char TOKEN_DQUOTE = '\"';
    private static final char TOKEN_SQUOTE = '\'';
    public static final int TYPE_KEY_START = 0;
    public static final Token TOKEN_KEY_START_OBJECT = new Token(String.valueOf('('), 0);
    public static final int TYPE_KEY_END = 1;
    public static final Token TOKEN_KEY_END_OBJECT = new Token(String.valueOf(')'), 1);
    public static final int TYPE_EQUAL = 2;
    public static final Token TOKEN_EQUAL_OBJECT = new Token(String.valueOf('='), 2);
    public static final int TYPE_LITERAL = 3;
    public static final int TYPE_EOF = -1;
    public static final Token TOKEN_EOF_OBJECT = new Token("EOF", -1);
    private final List<Token> tokenList = new ArrayList<Token>();
    private int tokenPosition = 0;
    private final String connectionString;
    private int position = 0;

    public OracleNetConnectionDescriptorTokenizer(String connectionString) {
        if (connectionString == null) {
            throw new RuntimeException("connectionString");
        }
        this.connectionString = connectionString;
    }

    public void parse() {
        int length = this.connectionString.length();
        while (this.position < length) {
            char ch = this.connectionString.charAt(this.position);
            if (!this.isWhiteSpace(ch)) {
                switch (ch) {
                    case '(': {
                        this.tokenList.add(TOKEN_KEY_START_OBJECT);
                        break;
                    }
                    case '=': {
                        this.tokenList.add(TOKEN_EQUAL_OBJECT);
                        break;
                    }
                    case ')': {
                        this.tokenList.add(TOKEN_KEY_END_OBJECT);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case ',': 
                    case '\\': {
                        throw new RuntimeException("unsupported token:" + ch);
                    }
                    default: {
                        String literal = this.parseLiteral();
                        this.addToken(literal, 3);
                        break;
                    }
                }
            }
            ++this.position;
        }
        this.tokenList.add(TOKEN_EOF_OBJECT);
    }

    String parseLiteral() {
        int start;
        this.position = start = this.trimLeft();
        while (this.position < this.connectionString.length()) {
            char ch = this.connectionString.charAt(this.position);
            switch (ch) {
                case '(': 
                case ')': 
                case '=': {
                    int end = this.trimRight(this.position);
                    --this.position;
                    return this.connectionString.substring(start, end);
                }
            }
            ++this.position;
        }
        int end2 = this.trimRight(this.position);
        return this.connectionString.substring(start, end2);
    }

    int trimRight(int index) {
        int end;
        for (end = index; end > 0; --end) {
            char ch = this.connectionString.charAt(end - 1);
            if (this.isWhiteSpace(ch)) continue;
            return end;
        }
        return end;
    }

    int trimLeft() {
        int start;
        int length = this.connectionString.length();
        for (start = this.position; start < length; ++start) {
            char ch = this.connectionString.charAt(start);
            if (this.isWhiteSpace(ch)) continue;
            return start;
        }
        return start;
    }

    private void addToken(String tokenString, int type) {
        Token token = new Token(tokenString, type);
        this.tokenList.add(token);
    }

    private boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public Token nextToken() {
        if (this.tokenList.size() <= this.tokenPosition) {
            return null;
        }
        Token token = this.tokenList.get(this.tokenPosition);
        ++this.tokenPosition;
        return token;
    }

    public void nextPosition() {
        if (this.tokenList.size() <= this.tokenPosition) {
            return;
        }
        ++this.tokenPosition;
    }

    public Token lookAheadToken() {
        if (this.tokenList.size() <= this.tokenPosition) {
            return null;
        }
        return this.tokenList.get(this.tokenPosition);
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void checkStartToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new RuntimeException("parse error. token is null");
        }
        if (token != TOKEN_KEY_START_OBJECT) {
            throw new RuntimeException("syntax error. Expected token='(' :" + token.getToken());
        }
    }

    public void checkEqualToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new RuntimeException("parse error. token is null. Expected token='='");
        }
        if (token != TOKEN_EQUAL_OBJECT) {
            throw new RuntimeException("Syntax error. Expected token='=' :" + token.getToken());
        }
    }

    public void checkEndToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new RuntimeException("parse error. token is null. Expected token=')");
        }
        if (token != TOKEN_KEY_END_OBJECT) {
            throw new RuntimeException("Syntax error. Expected token=')' :" + token.getToken());
        }
    }

    public Token getLiteralToken() {
        Token token = this.nextToken();
        if (token == null) {
            throw new RuntimeException("parse error. token is null. Expected token='LITERAL'");
        }
        if (token.getType() != 3) {
            throw new RuntimeException("Syntax error. Expected token='LITERAL'' :" + token.getToken());
        }
        return token;
    }

    public Token getLiteralToken(String expectedValue) {
        Token token = this.nextToken();
        if (token == null) {
            throw new RuntimeException("parse error. token is null. Expected token='LITERAL'");
        }
        if (token.getType() != 3) {
            throw new RuntimeException("Syntax error. Expected token='LITERAL' :" + token.getToken());
        }
        if (!expectedValue.equals(token.getToken())) {
            throw new RuntimeException("Syntax error. Expected token=" + expectedValue + "' :" + token.getToken());
        }
        return token;
    }
}

