/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.likeescaper;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.struct.Entry;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Pair;
import com.jn.sqlhelper.common.utils.SQLs;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class LikeEscapers {
    private static final List<String> keywordsAfterLikeClause = Collects.asList((Object[])new String[]{"and", "or", "group", "order", "limit", "fetch", "offset", "window", "union", "into", "using", "plan", "for", "with"});

    private static String insert(final @NonNull String string, @Nullable List<Integer> slotIndexes, @NonNull String insertment) {
        Preconditions.checkNotNull((Object)string);
        if (Emptys.isEmpty(slotIndexes)) {
            return string;
        }
        final TreeSet sortedSlotIndexes = Collects.emptyTreeSet();
        final Holder insertFirst = new Holder((Object)false);
        final Holder insertLast = new Holder((Object)false);
        Collects.forEach(slotIndexes, (Consumer)new Consumer<Integer>(){

            public void accept(Integer slotIndex) {
                if (slotIndex <= 0) {
                    insertFirst.set((Object)true);
                } else if (slotIndex >= string.length()) {
                    insertLast.set((Object)true);
                } else {
                    sortedSlotIndexes.add(slotIndex);
                }
            }
        });
        final List sortedSlotIndexList = Pipeline.of((Iterable)sortedSlotIndexes).asList();
        final LinkedList<Entry> segmentOffsetPairs = new LinkedList<Entry>();
        Collects.forEach((Collection)sortedSlotIndexList, (Consumer2)new Consumer2<Integer, Integer>(){

            public void accept(Integer index, Integer slotIndex) {
                if (index == 0) {
                    segmentOffsetPairs.add(new Entry((Object)0, (Object)slotIndex));
                } else {
                    segmentOffsetPairs.add(new Entry(sortedSlotIndexList.get(index - 1), (Object)slotIndex));
                }
            }
        });
        if (Emptys.isEmpty((Object)sortedSlotIndexList)) {
            segmentOffsetPairs.add(new Entry((Object)0, (Object)string.length()));
        } else {
            int stringLength;
            int lastSlotIndex = (Integer)sortedSlotIndexList.get(sortedSlotIndexList.size() - 1);
            if (lastSlotIndex < (stringLength = string.length())) {
                segmentOffsetPairs.add(new Entry((Object)lastSlotIndex, (Object)stringLength));
            }
        }
        Collection segments = Collects.map(segmentOffsetPairs, (Function)new Function<Pair<Integer, Integer>, String>(){

            public String apply(Pair<Integer, Integer> pair) {
                return string.substring((Integer)pair.getKey(), (Integer)pair.getValue());
            }
        });
        StringBuilder newString = new StringBuilder(string.length() + 20);
        if (((Boolean)insertFirst.get()).booleanValue()) {
            newString.append(insertment);
        }
        Iterator segmentIter = segments.iterator();
        while (segmentIter.hasNext()) {
            String segment = (String)segmentIter.next();
            newString.append(segment);
            if (!segmentIter.hasNext()) continue;
            newString.append(insertment);
        }
        if (((Boolean)insertLast.get()).booleanValue()) {
            newString.append(insertment);
        }
        return newString.toString();
    }

    public static String insertLikeEscapeDeclares(@NonNull String sql, @Nullable List<Integer> slotIndexes, @NonNull LikeEscaper escaper) {
        return LikeEscapers.insert(sql, slotIndexes, escaper.appendmentAfterLikeClause());
    }

    public static Pair<List<Integer>, List<Integer>> findEscapedSlots(String sql) {
        String normalDelimiter = " \t\n\r\f',";
        StringTokenizer tokenizer = new StringTokenizer(sql.toLowerCase(), normalDelimiter, true);
        int singleQuoteCount = 0;
        List parameterPlaceholderIndexes = Collects.emptyArrayList();
        List escapeDeclareSlotIndexes = Collects.emptyArrayList();
        int readedLength = 0;
        int segmentStartIndex = 0;
        int readedParameterCount = 0;
        boolean inLikeClause = false;
        while (tokenizer.hasMoreTokens()) {
            String segment;
            String token = tokenizer.nextToken();
            if (singleQuoteCount % 2 == 1 && !"'".equals(token)) {
                readedLength += token.length();
                continue;
            }
            if (Strings.isBlank((String)token)) {
                readedLength += token.length();
                continue;
            }
            if ("'".equals(token)) {
                ++singleQuoteCount;
                ++readedLength;
                continue;
            }
            if (",".equals(token)) {
                ++readedLength;
                continue;
            }
            if ("like".equals(token) && singleQuoteCount % 2 == 0) {
                inLikeClause = true;
                segment = sql.substring(segmentStartIndex, readedLength);
                readedParameterCount += SQLs.findPlaceholderParameterCount((String)segment);
                segmentStartIndex = readedLength += token.length();
                continue;
            }
            if (inLikeClause && singleQuoteCount % 2 == 0 && keywordsAfterLikeClause.contains(token)) {
                inLikeClause = false;
                segment = sql.substring(segmentStartIndex, readedLength);
                int parameterCountInLikeClause = SQLs.findPlaceholderParameterCount((String)segment);
                if (parameterCountInLikeClause > 0) {
                    escapeDeclareSlotIndexes.add(readedLength);
                    for (int i = 0; i < parameterCountInLikeClause; ++i) {
                        parameterPlaceholderIndexes.add(readedParameterCount + i);
                    }
                    readedParameterCount += parameterCountInLikeClause;
                }
                segmentStartIndex = readedLength;
                continue;
            }
            readedLength += token.length();
        }
        if (inLikeClause && singleQuoteCount % 2 == 0) {
            inLikeClause = false;
            String segment = sql.substring(segmentStartIndex);
            int parameterCountInLikeClause = SQLs.findPlaceholderParameterCount((String)segment);
            if (parameterCountInLikeClause > 0) {
                escapeDeclareSlotIndexes.add(readedLength);
                for (int i = 0; i < parameterCountInLikeClause; ++i) {
                    parameterPlaceholderIndexes.add(readedParameterCount + i);
                }
                readedParameterCount += parameterCountInLikeClause;
            }
            segmentStartIndex = readedLength;
        }
        return new Entry((Object)parameterPlaceholderIndexes, (Object)escapeDeclareSlotIndexes);
    }
}

