/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.orderby;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.symbolmapper.NoopSymbolMapper;
import com.jn.sqlhelper.common.symbolmapper.SqlSymbolMapper;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.orderby.OrderByBuilder;
import com.jn.sqlhelper.dialect.orderby.OrderByItem;
import com.jn.sqlhelper.dialect.orderby.OrderBySymbolException;
import com.jn.sqlhelper.dialect.orderby.OrderByType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class SymbolStyleOrderByBuilder
implements OrderByBuilder<String> {
    private String ascSymbol;
    private String descSymbol;
    private Map<String, String> symbolMap = new HashMap<String, String>();
    private SqlSymbolMapper sqlSymbolMapper = NoopSymbolMapper.DEFAULT;
    public static final SymbolStyleOrderByBuilder MATH_SYMBOL_ORDER_BY_BUILDER = new SymbolStyleOrderByBuilder("+", "-");

    public SymbolStyleOrderByBuilder() {
    }

    public SymbolStyleOrderByBuilder(String ascSymbol, String descSymbol) {
        this.ascSymbol(ascSymbol);
        this.descSymbol(descSymbol);
    }

    public SymbolStyleOrderByBuilder sqlSymbolMapper(SqlSymbolMapper sqlSymbolMapper) {
        if (sqlSymbolMapper != null) {
            this.sqlSymbolMapper = sqlSymbolMapper;
        }
        return this;
    }

    @Override
    public OrderBy build(String s) {
        if (Strings.isBlank((String)this.ascSymbol) || Strings.isBlank((String)this.descSymbol)) {
            throw new OrderBySymbolException("OrderByBuilder symbol is illegal, ascSymbol:" + this.ascSymbol + ",descSymbol:" + this.descSymbol);
        }
        if (Strings.isBlank((String)s)) {
            return OrderBy.EMPTY;
        }
        OrderBy orderBy = new OrderBy();
        String currentSymbol = null;
        String currentExpression = null;
        StringTokenizer tokenizer = new StringTokenizer(s, " \t\n\r\f,", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (Strings.isBlank((String)token)) continue;
            boolean isAscSymbol = this.ascSymbol.equals(token);
            boolean isDescSymbol = this.descSymbol.equals(token);
            boolean isDelimiter = ",".equals(token);
            if (isAscSymbol || isDescSymbol) {
                currentSymbol = token;
                continue;
            }
            if (!isDelimiter) {
                String lastOrderBySymbolForCurrentExpression = null;
                while (token.startsWith(this.ascSymbol) || token.startsWith(this.descSymbol)) {
                    if (token.startsWith(this.ascSymbol)) {
                        token = token.substring(this.ascSymbol.length());
                        lastOrderBySymbolForCurrentExpression = this.ascSymbol;
                        continue;
                    }
                    token = token.substring(this.descSymbol.length());
                    lastOrderBySymbolForCurrentExpression = this.descSymbol;
                }
                while (token.endsWith(this.ascSymbol) || token.endsWith(this.descSymbol)) {
                    if (token.endsWith(this.ascSymbol)) {
                        token = token.substring(0, token.lastIndexOf(this.ascSymbol));
                        lastOrderBySymbolForCurrentExpression = this.ascSymbol;
                        continue;
                    }
                    token = token.substring(0, token.lastIndexOf(this.descSymbol));
                    lastOrderBySymbolForCurrentExpression = this.descSymbol;
                }
                if (lastOrderBySymbolForCurrentExpression != null) {
                    currentSymbol = lastOrderBySymbolForCurrentExpression;
                }
                currentExpression = token;
                continue;
            }
            if (currentExpression != null) {
                orderBy.add(new OrderByItem((String)this.sqlSymbolMapper.apply(currentExpression), OrderByType.fromString(this.symbolMap.get(currentSymbol))));
            }
            currentExpression = null;
            currentSymbol = null;
        }
        if (currentExpression != null) {
            orderBy.add(new OrderByItem((String)this.sqlSymbolMapper.apply(currentExpression), OrderByType.fromString(this.symbolMap.get(currentSymbol))));
        }
        return orderBy;
    }

    public String ascSymbol() {
        return this.ascSymbol;
    }

    public SymbolStyleOrderByBuilder ascSymbol(String ascSymbol) {
        if (this.isValidSymbol(ascSymbol)) {
            this.ascSymbol = ascSymbol;
            this.removeSymbolMapForValue("asc");
            this.symbolMap.put(ascSymbol, "asc");
        }
        return this;
    }

    public SymbolStyleOrderByBuilder descSymbol(String descSymbol) {
        if (this.isValidSymbol(descSymbol)) {
            this.descSymbol = descSymbol;
            this.removeSymbolMapForValue("desc");
            this.symbolMap.put(descSymbol, "desc");
        }
        return this;
    }

    private void removeSymbolMapForValue(@NonNull String value) {
        Iterator<Map.Entry<String, String>> iter = this.symbolMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!value.equals(entry.getValue())) continue;
            iter.remove();
        }
    }

    private boolean isValidSymbol(String symbol) {
        if (Strings.isBlank((String)symbol)) {
            return false;
        }
        return !"?".equals(symbol = symbol.trim());
    }
}

