/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.pagination;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;

public class PagedPreparedStatement
implements PreparedStatement {
    private PreparedStatement delegate;
    private int indexOffset = -1;
    private final Set<Integer> setParameterIndexes = new LinkedHashSet<Integer>();

    public Set<Integer> getSetParameterIndexes() {
        return this.setParameterIndexes;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public PagedPreparedStatement(PreparedStatement delegate) {
        this.delegate = delegate;
    }

    private void recordParameterSet(int index) {
        if (this.indexOffset >= 0) {
            this.setParameterIndexes.add(index);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.delegate.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.delegate.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.delegate.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.delegate.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.delegate.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setNClob(parameterIndex, reader);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.delegate.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.delegate.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.delegate.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.delegate.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.delegate.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.delegate.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.delegate.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.delegate.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.delegate.isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.delegate.isCloseOnCompletion();
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        if (this.indexOffset >= 0) {
            this.recordParameterSet(parameterIndex += this.indexOffset);
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.delegate.executeLargeUpdate();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.delegate.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.delegate.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.delegate.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.delegate.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.delegate.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.delegate.executeLargeUpdate(sql, columnNames);
    }
}

