/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.pagination;

import com.jn.langx.util.collection.Collects;
import com.jn.sqlhelper.dialect.SelectRequest;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContext;
import com.jn.sqlhelper.dialect.pagination.PagingResult;

public class PagingRequest<C, E>
extends SelectRequest<PagingRequest<C, E>, PagingRequestContext<C, E>> {
    private static final long serialVersionUID = 1L;
    private Boolean count = null;
    private String countColumn;
    private Boolean cacheCount = null;
    private int pageNo = 1;
    private int pageSize;
    private Boolean useLastPageIfPageOut;
    private C condition;
    private transient PagingResult<E> result;
    private boolean isSubQueryPaging = false;
    private String subqueryPagingStartFlag;
    private String subqueryPagingEndFlag;

    public boolean isEmptyRequest() {
        return this.pageSize == 0;
    }

    public boolean isGetAllRequest() {
        return this.pageSize < 0 && this.pageNo == 1;
    }

    public boolean isGetAllFromNonZeroOffsetRequest() {
        return this.pageSize < 0 && this.pageNo > 1;
    }

    public boolean isValidRequest() {
        return this.pageSize > 0 || this.isGetAllFromNonZeroOffsetRequest();
    }

    public PagingRequest<C, E> limit(int pageNo, int pageSize) {
        return this.setPageNo(pageNo).setPageSize(pageSize);
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public PagingRequest<C, E> setPageNo(int pageNo) {
        if (pageNo <= 0) {
            return this;
        }
        this.pageNo = pageNo;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PagingRequest<C, E> setPageSize(int pageSize) {
        if (pageSize < 0) {
            this.pageSize = -1;
            return this;
        }
        this.pageSize = pageSize;
        return this;
    }

    public C getCondition() {
        return this.condition;
    }

    public PagingRequest<C, E> setCondition(C condition) {
        this.condition = condition;
        return this;
    }

    public Boolean needCount() {
        return this.count;
    }

    public PagingRequest<C, E> setCount(Boolean count) {
        this.count = count;
        return this;
    }

    public PagingResult<E> getResult() {
        return this.result;
    }

    public PagingRequest<C, E> setResult(PagingResult<E> result) {
        this.result = result;
        return this;
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public void clear(boolean clearResult) {
        super.clear();
        this.count = null;
        this.useLastPageIfPageOut = null;
        this.setCtx(null);
        if (clearResult && this.result != null) {
            this.result.setItems(Collects.emptyArrayList());
        }
        this.setCondition(null);
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    public void setCountColumn(String countColumn) {
        this.countColumn = countColumn;
    }

    public Boolean getCacheCount() {
        return this.cacheCount;
    }

    public PagingRequest<C, E> setCacheCount(Boolean cacheCount) {
        this.cacheCount = cacheCount;
        return this;
    }

    public PagingRequest<C, E> setCtx(PagingRequestContext ctx) {
        return (PagingRequest)this.setContext(ctx);
    }

    public Boolean isUseLastPageIfPageOut() {
        return this.useLastPageIfPageOut;
    }

    public PagingRequest<C, E> setUseLastPageIfPageOut(Boolean useLastPageIfPageNoOut) {
        this.useLastPageIfPageOut = useLastPageIfPageNoOut;
        return this;
    }

    @Deprecated
    public PagingRequest<C, E> setUseLastPageIfPageNoOut(Boolean useLastPageIfPageNoOut) {
        return this.setUseLastPageIfPageOut(useLastPageIfPageNoOut);
    }

    public String getSubqueryPagingStartFlag() {
        return this.subqueryPagingStartFlag;
    }

    public PagingRequest<C, E> setSubqueryPagingStartFlag(String subqueryPagingStartFlag) {
        this.subqueryPagingStartFlag = subqueryPagingStartFlag;
        return this;
    }

    public String getSubqueryPagingEndFlag() {
        return this.subqueryPagingEndFlag;
    }

    public PagingRequest<C, E> setSubqueryPagingEndFlag(String subqueryPagingEndFlag) {
        this.subqueryPagingEndFlag = subqueryPagingEndFlag;
        return this;
    }

    public boolean isSubqueryPaging() {
        return this.isSubQueryPaging;
    }

    public PagingRequest<C, E> subqueryPaging(boolean subQueryPaging) {
        this.isSubQueryPaging = subQueryPaging;
        return this;
    }

    public PagingRequest<C, E> subqueryPaging(String subQueryPagingStartFlag, String subQueryPagingEndFlag) {
        return this.subqueryPaging(true).setSubqueryPagingStartFlag(subQueryPagingStartFlag).setSubqueryPagingEndFlag(subQueryPagingEndFlag);
    }

    public String toString() {
        return "PagingRequest{count=" + this.count + ", countColumn='" + this.countColumn + '\'' + ", cacheCount=" + this.cacheCount + ", pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", useLastPageIfPageOut=" + this.useLastPageIfPageOut + ", condition=" + this.condition + ", result=" + this.result + ", isSubQueryPaging=" + this.isSubQueryPaging + ", subqueryPagingStartFlag='" + this.subqueryPagingStartFlag + '\'' + ", subqueryPagingEndFlag='" + this.subqueryPagingEndFlag + '\'' + ", dialect='" + this.getDialect() + '\'' + '}';
    }

    @Override
    public boolean isPagingRequest() {
        return true;
    }
}

