/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.pagination;

import com.jn.langx.util.Objects;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.dialect.SqlRequestContext;
import com.jn.sqlhelper.dialect.SqlRequestContextHolder;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContext;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingRequestContextHolder
extends SqlRequestContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(PagingRequestContextHolder.class);
    private static final PagingRequestContextHolder INSTANCE = new PagingRequestContextHolder();

    private PagingRequestContextHolder() {
    }

    public static PagingRequestContextHolder getContext() {
        return INSTANCE;
    }

    private PagingRequestContext newOne() {
        try {
            return (PagingRequestContext)((Object)PagingRequestContext.class.newInstance());
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            return null;
        }
    }

    public void setPagingRequest(final PagingRequest request) {
        this.setContextContent(new Consumer<PagingRequestContext>(){

            public void accept(PagingRequestContext context) {
                context.setRequest(request);
                request.setCtx(context);
            }
        });
    }

    public void setRowSelection(final RowSelection rowSelection) {
        this.setContextContent(new Consumer<PagingRequestContext>(){

            public void accept(PagingRequestContext context) {
                context.setRowSelection(rowSelection);
            }
        });
    }

    private <X> void setContextContent(Consumer<PagingRequestContext> consumer) {
        PagingRequestContext context = this.get();
        if (Objects.isNull((Object)((Object)context)) && Objects.isNull((Object)((Object)(context = this.newOne())))) {
            variables.remove();
        }
        if (Objects.isNotNull((Object)((Object)context))) {
            variables.set(context);
            consumer.accept((Object)context);
        }
    }

    @Override
    public PagingRequestContext get() {
        SqlRequestContext context = (SqlRequestContext)((Object)variables.get());
        if (Objects.isNotNull((Object)((Object)context)) && context.isPagingRequest()) {
            return (PagingRequestContext)context;
        }
        return null;
    }

    public void set(PagingRequestContext ctx) {
        variables.set(ctx);
    }

    public PagingRequest getPagingRequest() {
        PagingRequestContext context = this.get();
        if (Objects.isNotNull((Object)((Object)context))) {
            return context.getRequest();
        }
        return null;
    }

    public RowSelection getRowSelection() {
        PagingRequestContext context = this.get();
        if (Objects.isNotNull((Object)((Object)context))) {
            return context.getRowSelection();
        }
        return null;
    }

    public void remove() {
        variables.remove();
    }

    public boolean isPagingRequest() {
        return this.getPagingRequest() != null;
    }
}

