/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.properties.Props;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.struct.Holder;
import com.jn.sqlhelper.common.ddl.SQLSyntaxCompatTable;
import com.jn.sqlhelper.common.utils.Connections;
import com.jn.sqlhelper.dialect.DatabaseMetaDataDialectResolutionInfoAdapter;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.DialectResolutionInfo;
import com.jn.sqlhelper.dialect.annotation.Driver;
import com.jn.sqlhelper.dialect.annotation.SyntaxCompat;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.AccessDialect;
import com.jn.sqlhelper.dialect.internal.ActorDBDialect;
import com.jn.sqlhelper.dialect.internal.AgensGraphDialect;
import com.jn.sqlhelper.dialect.internal.AliSQLDialect;
import com.jn.sqlhelper.dialect.internal.AltibaseDialect;
import com.jn.sqlhelper.dialect.internal.AntDBDialect;
import com.jn.sqlhelper.dialect.internal.ArgoDBDialect;
import com.jn.sqlhelper.dialect.internal.As400Dialect;
import com.jn.sqlhelper.dialect.internal.AuroraDialect;
import com.jn.sqlhelper.dialect.internal.AzureDialect;
import com.jn.sqlhelper.dialect.internal.BesMagicDataDialect;
import com.jn.sqlhelper.dialect.internal.BigObjectDialect;
import com.jn.sqlhelper.dialect.internal.BrytlytDialect;
import com.jn.sqlhelper.dialect.internal.CTreeDialect;
import com.jn.sqlhelper.dialect.internal.CacheDialect;
import com.jn.sqlhelper.dialect.internal.CitusDialect;
import com.jn.sqlhelper.dialect.internal.ClickHouseDialect;
import com.jn.sqlhelper.dialect.internal.ClustrixDialect;
import com.jn.sqlhelper.dialect.internal.CobolDialect;
import com.jn.sqlhelper.dialect.internal.CockroachDialect;
import com.jn.sqlhelper.dialect.internal.ComDB2Dialect;
import com.jn.sqlhelper.dialect.internal.CovenantSQLDialect;
import com.jn.sqlhelper.dialect.internal.CrateDialect;
import com.jn.sqlhelper.dialect.internal.CubridDialect;
import com.jn.sqlhelper.dialect.internal.DB2Dialect;
import com.jn.sqlhelper.dialect.internal.DbfDialect;
import com.jn.sqlhelper.dialect.internal.DerbyDialect;
import com.jn.sqlhelper.dialect.internal.DmDialect;
import com.jn.sqlhelper.dialect.internal.DorisDialect;
import com.jn.sqlhelper.dialect.internal.DrillDialect;
import com.jn.sqlhelper.dialect.internal.ElasticsearchDialect;
import com.jn.sqlhelper.dialect.internal.EsgynDBDialect;
import com.jn.sqlhelper.dialect.internal.FileMakerDialect;
import com.jn.sqlhelper.dialect.internal.FirebirdDialect;
import com.jn.sqlhelper.dialect.internal.GBase8sDialect;
import com.jn.sqlhelper.dialect.internal.GBaseDialect;
import com.jn.sqlhelper.dialect.internal.GaussDbDialect;
import com.jn.sqlhelper.dialect.internal.GoldenDBDialect;
import com.jn.sqlhelper.dialect.internal.GreenplumDialect;
import com.jn.sqlhelper.dialect.internal.H2Dialect;
import com.jn.sqlhelper.dialect.internal.HANADialect;
import com.jn.sqlhelper.dialect.internal.HSQLDialect;
import com.jn.sqlhelper.dialect.internal.HawqDialect;
import com.jn.sqlhelper.dialect.internal.HerdDBDialect;
import com.jn.sqlhelper.dialect.internal.HhDbDialect;
import com.jn.sqlhelper.dialect.internal.HighGoDialect;
import com.jn.sqlhelper.dialect.internal.HiveDialect;
import com.jn.sqlhelper.dialect.internal.IgniteDialect;
import com.jn.sqlhelper.dialect.internal.ImpalaDialect;
import com.jn.sqlhelper.dialect.internal.InformixDialect;
import com.jn.sqlhelper.dialect.internal.IngresDialect;
import com.jn.sqlhelper.dialect.internal.InterbaseDialect;
import com.jn.sqlhelper.dialect.internal.IrisDialect;
import com.jn.sqlhelper.dialect.internal.JDataStoreDialect;
import com.jn.sqlhelper.dialect.internal.KDBDialect;
import com.jn.sqlhelper.dialect.internal.KarelDBDialect;
import com.jn.sqlhelper.dialect.internal.KineticaDialect;
import com.jn.sqlhelper.dialect.internal.KingDBDialect;
import com.jn.sqlhelper.dialect.internal.KingbaseDialect;
import com.jn.sqlhelper.dialect.internal.KognitioDialect;
import com.jn.sqlhelper.dialect.internal.LeanXcaleDialect;
import com.jn.sqlhelper.dialect.internal.LinterDialect;
import com.jn.sqlhelper.dialect.internal.MSQLDialect;
import com.jn.sqlhelper.dialect.internal.MariaDBDialect;
import com.jn.sqlhelper.dialect.internal.MaxComputeDialect;
import com.jn.sqlhelper.dialect.internal.MaxDBDialect;
import com.jn.sqlhelper.dialect.internal.MckoiDialect;
import com.jn.sqlhelper.dialect.internal.MemSQLDialect;
import com.jn.sqlhelper.dialect.internal.MimerSQLDialect;
import com.jn.sqlhelper.dialect.internal.MonetDialect;
import com.jn.sqlhelper.dialect.internal.MySQLDialect;
import com.jn.sqlhelper.dialect.internal.Neo4jDialect;
import com.jn.sqlhelper.dialect.internal.NetezzaDialect;
import com.jn.sqlhelper.dialect.internal.NexusDBDialect;
import com.jn.sqlhelper.dialect.internal.NuodbDialect;
import com.jn.sqlhelper.dialect.internal.OBaseDialect;
import com.jn.sqlhelper.dialect.internal.OmnisciDialect;
import com.jn.sqlhelper.dialect.internal.OpenEdgeDialect;
import com.jn.sqlhelper.dialect.internal.OpenbaseDialect;
import com.jn.sqlhelper.dialect.internal.OracleDialect;
import com.jn.sqlhelper.dialect.internal.OrientDBDialect;
import com.jn.sqlhelper.dialect.internal.OscarDialect;
import com.jn.sqlhelper.dialect.internal.ParadoxDialect;
import com.jn.sqlhelper.dialect.internal.PerconaMysqlDialect;
import com.jn.sqlhelper.dialect.internal.PhoenixDialect;
import com.jn.sqlhelper.dialect.internal.PointbaseDialect;
import com.jn.sqlhelper.dialect.internal.PostgreSQLDialect;
import com.jn.sqlhelper.dialect.internal.PrestoDialect;
import com.jn.sqlhelper.dialect.internal.RBaseDialect;
import com.jn.sqlhelper.dialect.internal.RDMSOS2200Dialect;
import com.jn.sqlhelper.dialect.internal.RadonDBDialect;
import com.jn.sqlhelper.dialect.internal.RaimaDialect;
import com.jn.sqlhelper.dialect.internal.RedshiftDialect;
import com.jn.sqlhelper.dialect.internal.SQLServerDialect;
import com.jn.sqlhelper.dialect.internal.SQLiteDialect;
import com.jn.sqlhelper.dialect.internal.SQReamDialect;
import com.jn.sqlhelper.dialect.internal.SadasDialect;
import com.jn.sqlhelper.dialect.internal.SequoiaDBDialect;
import com.jn.sqlhelper.dialect.internal.SinoDBDialect;
import com.jn.sqlhelper.dialect.internal.SmallDialect;
import com.jn.sqlhelper.dialect.internal.SnappyDataDialect;
import com.jn.sqlhelper.dialect.internal.SnowflakeDialect;
import com.jn.sqlhelper.dialect.internal.SpliceMachineDialect;
import com.jn.sqlhelper.dialect.internal.TajoDialect;
import com.jn.sqlhelper.dialect.internal.TeradataDialect;
import com.jn.sqlhelper.dialect.internal.TiDBDialect;
import com.jn.sqlhelper.dialect.internal.TimesTenDialect;
import com.jn.sqlhelper.dialect.internal.TrafodionDialect;
import com.jn.sqlhelper.dialect.internal.TransbaseDialect;
import com.jn.sqlhelper.dialect.internal.UxDBDialect;
import com.jn.sqlhelper.dialect.internal.ValentinaDialect;
import com.jn.sqlhelper.dialect.internal.VerticaDialect;
import com.jn.sqlhelper.dialect.internal.VirtuosoDialect;
import com.jn.sqlhelper.dialect.internal.VistaDBDialect;
import com.jn.sqlhelper.dialect.internal.VoltDBDialect;
import com.jn.sqlhelper.dialect.internal.XCloudDBDialect;
import com.jn.sqlhelper.dialect.internal.XtremeSQLDialect;
import com.jn.sqlhelper.dialect.internal.XuguDialect;
import com.jn.sqlhelper.dialect.internal.YaacomoDialect;
import com.jn.sqlhelper.dialect.internal.YugabyteDBDialect;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import com.jn.sqlhelper.dialect.urlparser.JdbcUrlParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DialectRegistry.class);
    private static final Map<String, Dialect> nameToDialectMap = new TreeMap<String, Dialect>();
    private static final Map<String, String> classNameToNameMap = new TreeMap<String, String>();
    private static final Map<String, Holder<Dialect>> dbToDialectMap = new HashMap<String, Holder<Dialect>>();
    private static final Properties vendorDatabaseIdMappings = new Properties();
    private static final DialectRegistry registry = new DialectRegistry();

    private DialectRegistry() {
    }

    public static DialectRegistry getInstance() {
        return registry;
    }

    private static String databaseIdStringLowerCase(DatabaseMetaData databaseMetaData) {
        return DialectRegistry.databaseIdString(databaseMetaData).toLowerCase();
    }

    public static String databaseIdString(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException ex) {
            try {
                return databaseMetaData.getDriverName().toLowerCase() + " version: " + databaseMetaData.getDriverVersion().toLowerCase();
            }
            catch (SQLException sQLException) {
                try {
                    return databaseMetaData.getURL();
                }
                catch (SQLException ex2) {
                    logger.warn(ex2.getMessage(), (Throwable)ex2);
                    return databaseMetaData.getClass().getCanonicalName();
                }
            }
        }
    }

    private static void loadCustomDialects() {
        DialectRegistry.loadCustomDialects(DialectRegistry.class.getClassLoader());
    }

    public static void loadCustomDialects(ClassLoader classLoader) {
        ServiceLoader<AbstractDialect> serviceLoader = ServiceLoader.load(AbstractDialect.class, classLoader);
        for (AbstractDialect dialect : serviceLoader) {
            DialectRegistry.registerDialectByClass(dialect.getClass(), dialect);
        }
    }

    private static void registerBuiltinDialects() {
        logger.info("Start to register builtin dialects");
        Class[] dialects = new Class[]{AccessDialect.class, ActorDBDialect.class, AgensGraphDialect.class, AliSQLDialect.class, AltibaseDialect.class, AntDBDialect.class, AuroraDialect.class, ArgoDBDialect.class, AzureDialect.class, As400Dialect.class, BesMagicDataDialect.class, BigObjectDialect.class, BrytlytDialect.class, CacheDialect.class, CitusDialect.class, ClickHouseDialect.class, ClustrixDialect.class, CobolDialect.class, CockroachDialect.class, ComDB2Dialect.class, CovenantSQLDialect.class, CrateDialect.class, CTreeDialect.class, CubridDialect.class, DB2Dialect.class, DbfDialect.class, DerbyDialect.class, DmDialect.class, DorisDialect.class, DrillDialect.class, ElasticsearchDialect.class, EsgynDBDialect.class, FileMakerDialect.class, FirebirdDialect.class, GaussDbDialect.class, GBaseDialect.class, GBase8sDialect.class, GoldenDBDialect.class, GreenplumDialect.class, H2Dialect.class, HANADialect.class, HawqDialect.class, HerdDBDialect.class, HhDbDialect.class, HighGoDialect.class, HiveDialect.class, HSQLDialect.class, IgniteDialect.class, ImpalaDialect.class, InformixDialect.class, IngresDialect.class, InterbaseDialect.class, IrisDialect.class, JDataStoreDialect.class, KarelDBDialect.class, KDBDialect.class, KingbaseDialect.class, KingDBDialect.class, KineticaDialect.class, KognitioDialect.class, LeanXcaleDialect.class, LinterDialect.class, MariaDBDialect.class, MaxComputeDialect.class, MaxDBDialect.class, MckoiDialect.class, MemSQLDialect.class, MimerSQLDialect.class, MonetDialect.class, MSQLDialect.class, MySQLDialect.class, Neo4jDialect.class, NetezzaDialect.class, NexusDBDialect.class, NuodbDialect.class, OBaseDialect.class, OmnisciDialect.class, OpenbaseDialect.class, OpenEdgeDialect.class, OracleDialect.class, OrientDBDialect.class, OscarDialect.class, ParadoxDialect.class, PerconaMysqlDialect.class, PhoenixDialect.class, PointbaseDialect.class, PostgreSQLDialect.class, PrestoDialect.class, RadonDBDialect.class, RaimaDialect.class, RBaseDialect.class, RDMSOS2200Dialect.class, RedshiftDialect.class, SadasDialect.class, SequoiaDBDialect.class, SinoDBDialect.class, SmallDialect.class, SnappyDataDialect.class, SnowflakeDialect.class, SpliceMachineDialect.class, SQLiteDialect.class, SQLServerDialect.class, SQLServerDialect.SQLServer2000Dialect.class, SQLServerDialect.SQLServer2005Dialect.class, SQLServerDialect.SQLServer2008Dialect.class, SQLServerDialect.SQLServer2012Dialect.class, SQLServerDialect.SQLServer2014Dialect.class, SQLServerDialect.SQLServer2016Dialect.class, SQLServerDialect.SQLServer2017Dialect.class, SQReamDialect.class, TajoDialect.class, TeradataDialect.class, TiDBDialect.class, TimesTenDialect.class, TrafodionDialect.class, TransbaseDialect.class, UxDBDialect.class, ValentinaDialect.class, VerticaDialect.class, VirtuosoDialect.class, VistaDBDialect.class, VoltDBDialect.class, XtremeSQLDialect.class, XuguDialect.class, XCloudDBDialect.class, YaacomoDialect.class, YugabyteDBDialect.class};
        for (Class clazz : Arrays.asList(dialects)) {
            DialectRegistry.registerDialectByClass(clazz, null);
        }
        logger.info("Registered dialects: {}", nameToDialectMap.keySet());
    }

    private static void loadDatabaseIdMappings() {
        logger.info("Start to load database id mappings");
        try {
            Properties props = Props.loadFromClasspath((String)"/sqlhelper-dialect-databaseid.properties");
            vendorDatabaseIdMappings.putAll((Map<?, ?>)props);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    public static Properties getVendorDatabaseIdMappings() {
        return vendorDatabaseIdMappings;
    }

    public static void setDatabaseId(String keywordsInDriver, String databaseId) {
        DialectRegistry.setDatabaseIdIfAbsent(keywordsInDriver, databaseId);
    }

    public static void setDatabaseIdIfAbsent(String keywordsInDriver, String databaseId) {
        if (!vendorDatabaseIdMappings.containsKey(keywordsInDriver)) {
            vendorDatabaseIdMappings.setProperty(keywordsInDriver, databaseId);
        }
    }

    public static String guessDatabaseId(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource cannot be null");
        }
        try {
            return DialectRegistry.guessDatabaseId(Connections.getDatabaseProductName((DataSource)dataSource));
        }
        catch (Exception e) {
            logger.error("Could not get a databaseId from dataSource", (Throwable)e);
            return null;
        }
    }

    public static String guessDatabaseId(String productName) {
        int urlPropertyFragmentIndex;
        if (productName == null) {
            return null;
        }
        String tmpProductName = productName.toLowerCase();
        int urlProtocolIndex = tmpProductName.indexOf("://");
        if (urlProtocolIndex != -1) {
            DatabaseInfo databaseInfo = new JdbcUrlParser().parse(productName);
            tmpProductName = databaseInfo != null && !"unknown".equals(databaseInfo.getVendor().toLowerCase()) ? databaseInfo.getVendor().toLowerCase() : tmpProductName.substring(0, urlProtocolIndex);
        }
        if ((urlPropertyFragmentIndex = tmpProductName.indexOf("?")) != -1) {
            DatabaseInfo databaseInfo = new JdbcUrlParser().parse(productName);
            tmpProductName = databaseInfo != null && !"unknown".equals(databaseInfo.getVendor().toLowerCase()) ? databaseInfo.getVendor().toLowerCase() : tmpProductName.substring(0, urlPropertyFragmentIndex);
        }
        Object[] tokens = Strings.split((String)tmpProductName, (String)":");
        final Set<String> productKeywords = vendorDatabaseIdMappings.stringPropertyNames();
        final Holder matchedProductHolder = new Holder();
        Pipeline.of((Object[])tokens).filter((Predicate)new Predicate<String>(){

            public boolean test(String token) {
                return !Strings.equalsIgnoreCase((CharSequence)token, (CharSequence)"jdbc");
            }
        }).forEach((Consumer)new Consumer<String>(){

            public void accept(final String token) {
                String matchedProductKeyword = (String)Pipeline.of((Iterable)productKeywords).findFirst((Predicate)new Predicate<String>(){

                    public boolean test(String productKeyword) {
                        return token.contains(productKeyword.toLowerCase());
                    }
                });
                if (Strings.isNotBlank((String)matchedProductKeyword)) {
                    matchedProductHolder.set((Object)matchedProductKeyword);
                }
            }
        }, (Predicate)new Predicate<String>(){

            public boolean test(String token) {
                return !matchedProductHolder.isEmpty();
            }
        });
        String bestProductKeyword = (String)matchedProductHolder.get();
        if (Strings.isNotBlank((String)bestProductKeyword)) {
            return vendorDatabaseIdMappings.getProperty(bestProductKeyword);
        }
        if (classNameToNameMap.containsKey(tmpProductName)) {
            return classNameToNameMap.get(tmpProductName);
        }
        return null;
    }

    private static Class<? extends Dialect> loadDialectClass(String className) throws ClassNotFoundException {
        return DialectRegistry.loadImplClass(className, Dialect.class);
    }

    private static Class<? extends java.sql.Driver> loadDriverClass(String className) throws ClassNotFoundException {
        return DialectRegistry.loadImplClass(className, java.sql.Driver.class);
    }

    private static Class loadImplClass(String className, Class superClass) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, DialectRegistry.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        if (superClass.isAssignableFrom(clazz)) {
            return clazz;
        }
        String error = "Class " + Reflects.getFQNClassName(clazz) + " is not cast to " + Reflects.getFQNClassName((Class)superClass);
        throw new ClassCastException(error);
    }

    private static Dialect registerDialectByClass(Class<? extends Dialect> clazz) {
        return DialectRegistry.registerDialectByClass(clazz, null);
    }

    private static Dialect registerDialectByClass(@NonNull Class<? extends Dialect> dialectClass, @Nullable Dialect dialect) {
        SyntaxCompat syntaxCompat;
        String name;
        Preconditions.checkNotNull(dialectClass);
        Name nameAnno = (Name)Reflects.getAnnotation(dialectClass, Name.class);
        if (nameAnno != null) {
            name = nameAnno.value();
            if (Strings.isBlank((String)name)) {
                throw new IllegalStateException("@Name is empty in class" + Reflects.getFQNClassName(dialectClass));
            }
        } else {
            String simpleClassName = dialectClass.getSimpleName().toLowerCase();
            name = simpleClassName.replaceAll("dialect", "");
        }
        if (dialect == null) {
            Driver driverAnno = (Driver)Reflects.getAnnotation(dialectClass, Driver.class);
            Class<? extends java.sql.Driver> driverClass = null;
            Constructor<? extends Dialect> driverConstructor = null;
            if (driverAnno != null) {
                String[] driverClassNames = (String[])Pipeline.of((Object[])driverAnno.value()).filter((Predicate)new Predicate<String>(){

                    public boolean test(String driverClassName) {
                        return Strings.isNotBlank((String)driverClassName);
                    }
                }).toArray(String[].class);
                if (Objs.isEmpty((Object)driverClassNames)) {
                    throw new IllegalStateException("@Driver is empty in class" + Reflects.getFQNClassName(dialectClass));
                }
                for (int i = 0; i < driverClassNames.length; ++i) {
                    String driverClassName = driverClassNames[i];
                    try {
                        driverClass = DialectRegistry.loadDriverClass(driverClassName);
                        try {
                            driverConstructor = dialectClass.getDeclaredConstructor(java.sql.Driver.class);
                        }
                        catch (Throwable ex) {
                            logger.info("Can't find the driver based constructor for dialect {}", (Object)name);
                        }
                    }
                    catch (Throwable ex) {
                        logger.info("Can't find driver class {} for {} dialect", (Object)driverClassName, (Object)name);
                    }
                    if (driverClass != null) break;
                }
            }
            if (driverClass == null || driverConstructor == null) {
                try {
                    try {
                        dialect = dialectClass.newInstance();
                    }
                    catch (InstantiationException e2) {
                        String error = StringTemplates.formatWithPlaceholder((String)"Class {}  need a <init>()", (Object[])new Object[]{Reflects.getFQNClassName(dialectClass)});
                        throw new ClassFormatError(error);
                    }
                    catch (IllegalAccessException e3) {
                        String error = StringTemplates.formatWithPlaceholder((String)"Class {}  need a <init>()", (Object[])new Object[]{Reflects.getFQNClassName(dialectClass)});
                        throw new ClassFormatError(error);
                    }
                }
                catch (Throwable ex) {
                    logger.error("Register dialect {} fail: {}", new Object[]{name, ex.getMessage(), ex});
                }
            } else {
                try {
                    try {
                        final Class<? extends java.sql.Driver> expectDriverClass = driverClass;
                        java.sql.Driver driver = (java.sql.Driver)Pipeline.of(DriverManager.getDrivers()).findFirst((Predicate)new Predicate<java.sql.Driver>(){

                            public boolean test(java.sql.Driver d) {
                                return expectDriverClass.isInstance(d);
                            }
                        });
                        if (driver != null) {
                            driverConstructor.setAccessible(true);
                            dialect = (Dialect)driverConstructor.newInstance(driver);
                        }
                    }
                    catch (InstantiationException e2) {
                        String error = StringTemplates.formatWithPlaceholder((String)"Class {}  need a <init>(Driver)", (Object[])new Object[]{Reflects.getFQNClassName(dialectClass)});
                        throw new ClassFormatError(error);
                    }
                    catch (IllegalAccessException e3) {
                        String error = StringTemplates.formatWithPlaceholder((String)"Class {} need a public <init>(Driver", (Object[])new Object[]{Reflects.getFQNClassName(dialectClass)});
                        throw new ClassFormatError(error);
                    }
                    catch (InvocationTargetException e) {
                        logger.error("Register dialect {} fail: {}", new Object[]{name, e.getMessage(), e});
                    }
                }
                catch (Throwable ex) {
                    logger.error("Register dialect {} fail: {}", new Object[]{name, ex.getMessage(), ex});
                }
            }
        }
        if (dialect != null) {
            nameToDialectMap.put(name, dialect);
            classNameToNameMap.put(dialectClass.getCanonicalName(), name);
            DialectRegistry.setDatabaseId(name, name);
        }
        if (dialect != null && (syntaxCompat = (SyntaxCompat)Reflects.getAnnotation(dialectClass, SyntaxCompat.class)) != null && Emptys.isNotEmpty((Object)syntaxCompat.value())) {
            SQLSyntaxCompatTable.getInstance().register(name, syntaxCompat.value());
        }
        return dialect;
    }

    public Collection<Dialect> getDialects() {
        return nameToDialectMap.values();
    }

    public Dialect getDialectByClassName(String className) {
        String dialectName = classNameToNameMap.get(className);
        if (dialectName != null) {
            return this.getDialectByName(dialectName);
        }
        return null;
    }

    public Dialect getDialectByName(String databaseId) {
        return nameToDialectMap.get(databaseId);
    }

    public Dialect getDialectByDatabaseMetadata(DatabaseMetaData databaseMetaData) {
        Dialect dialect = null;
        if (databaseMetaData != null) {
            dialect = this.getDialectByResolutionInfo(new DatabaseMetaDataDialectResolutionInfoAdapter(databaseMetaData));
        }
        return dialect;
    }

    public Dialect getDialectByResolutionInfo(DialectResolutionInfo resolutionInfo) {
        String databaseIdString;
        Dialect dialect = null;
        if (resolutionInfo != null && (databaseIdString = resolutionInfo.getDatabaseProductName()) != null) {
            databaseIdString = Strings.lowerCase((String)resolutionInfo.getDatabaseProductName(), (Locale)Locale.ROOT);
            Holder<Dialect> dialectHolder = dbToDialectMap.get(databaseIdString);
            if (dialectHolder != null) {
                dialect = (Dialect)dialectHolder.get();
            }
            if (dialect == null) {
                Enumeration<?> keys = vendorDatabaseIdMappings.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!databaseIdString.contains(key.toLowerCase()) || (dialect = this.getDialectByName(vendorDatabaseIdMappings.getProperty(key))) == null) continue;
                    dbToDialectMap.put(databaseIdString, (Holder<Dialect>)new Holder((Object)dialect));
                    break;
                }
            }
            if (dialect == null && (Strings.containsAny((CharSequence)databaseIdString.toLowerCase(), (CharSequence)"sql server") || Strings.containsAny((CharSequence)databaseIdString.toLowerCase(), (CharSequence)"sqlserver"))) {
                try {
                    String tmpDatabaseId;
                    String productionVersion = resolutionInfo.getDatabaseProductVersion();
                    if (Strings.isBlank((String)productionVersion)) {
                        productionVersion = resolutionInfo.getDatabaseMajorVersion() + "";
                    }
                    if (Emptys.isNotEmpty((Object)(tmpDatabaseId = SQLServerDialect.guessDatabaseId(productionVersion))) && (dialect = this.getDialectByName(vendorDatabaseIdMappings.getProperty(tmpDatabaseId))) != null) {
                        dbToDialectMap.put(databaseIdString, (Holder<Dialect>)new Holder((Object)dialect));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return dialect;
    }

    public void registerDialectByClassName(String dialectClassName) throws ClassNotFoundException {
        this.registerDialect(null, dialectClassName);
    }

    public void registerDialect(String dialectName, String className) throws ClassNotFoundException {
        Class<? extends Dialect> clazz = DialectRegistry.loadDialectClass(className);
        try {
            Dialect dialect = DialectRegistry.registerDialectByClass(clazz);
            if (!Strings.isBlank((String)dialectName) && dialect != null) {
                nameToDialectMap.put(dialectName, dialect);
            }
        }
        catch (Throwable ex) {
            logger.info(ex.getMessage(), ex);
        }
    }

    static {
        DialectRegistry.loadDatabaseIdMappings();
        DialectRegistry.registerBuiltinDialects();
        DialectRegistry.loadCustomDialects();
    }
}

