/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.expression;

import com.jn.langx.el.expression.BaseExpression;
import com.jn.langx.util.hash.HashCodeBuilder;
import com.jn.sqlhelper.common.utils.SQLs;
import com.jn.sqlhelper.dialect.expression.SQLExpression;

public class ColumnExpression
extends BaseExpression<SQLExpression>
implements SQLExpression<SQLExpression> {
    private boolean catalogAtStart = true;
    private String catalog;
    private String schema;
    private String table;
    private String column;
    private String separator = ".";

    public ColumnExpression() {
    }

    public ColumnExpression(String column) {
        this(null, column);
    }

    public ColumnExpression(String table, String column) {
        this(null, null, table, column);
    }

    public ColumnExpression(String catalog, String schema, String table, String column) {
        this(catalog, schema, table, column, ".", true);
    }

    public ColumnExpression(String catalog, String schema, String table, String column, String separator, boolean catalogAtStart) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setTable(table);
        this.setColumn(column);
        this.setCatalogAtStart(catalogAtStart);
        this.setSeparator(separator);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isCatalogAtStart() {
        return this.catalogAtStart;
    }

    public void setCatalogAtStart(boolean catalogAtStart) {
        this.catalogAtStart = catalogAtStart;
    }

    public SQLExpression execute() {
        return this;
    }

    public String getTableFullyQualifiedName() {
        return SQLs.getTableFQN((String)this.catalog, (String)this.schema, (String)this.table, (String)this.separator, (boolean)this.catalogAtStart);
    }

    public String toString() {
        return this.getTableFullyQualifiedName() + this.separator + this.column;
    }

    public int hashCode() {
        return new HashCodeBuilder().with((Object)this.catalogAtStart).with((Object)this.separator).with((Object)this.catalog).with((Object)this.schema).with((Object)this.table).with((Object)this.column).build();
    }
}

