/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.expression.builder;

import com.jn.langx.el.expression.Expression;
import com.jn.langx.el.expression.operator.BinaryOperator;
import com.jn.langx.el.expression.operator.Operator;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.function.Supplier0;
import com.jn.sqlhelper.dialect.expression.ColumnExpression;
import com.jn.sqlhelper.dialect.expression.DoubleExpression;
import com.jn.sqlhelper.dialect.expression.IntegerOrLongExpression;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.dialect.expression.StringExpression;
import com.jn.sqlhelper.dialect.expression.builder.SQLExpressionBuilder;

public class BinaryOperatorExpressionBuilder<E extends SQLExpression & BinaryOperator, T extends BinaryOperatorExpressionBuilder<E, T>>
implements SQLExpressionBuilder<E> {
    protected String operateSymbol;
    protected SQLExpression left;
    protected SQLExpression right;
    private Supplier0<E> supplier;

    public T supplier(Supplier0<E> supplier) {
        this.supplier = supplier;
        return (T)this;
    }

    public T operateSymbol(String symbol) {
        this.operateSymbol = symbol;
        return (T)this;
    }

    public T left(String expression) {
        return this.left(expression, true);
    }

    public T left(String expression, boolean isColumn) {
        this.left = isColumn ? new ColumnExpression(expression) : new StringExpression(expression);
        return (T)this;
    }

    public T left(long expression) {
        this.left = new IntegerOrLongExpression(expression);
        return (T)this;
    }

    public T left(double expression) {
        this.left = new DoubleExpression(expression);
        return (T)this;
    }

    public T left(SQLExpression expression) {
        this.left = expression;
        return (T)this;
    }

    public T right(String expression) {
        return this.right(expression, false);
    }

    public T right(String expression, boolean isColumn) {
        this.right = isColumn ? new ColumnExpression(expression) : new StringExpression(expression);
        return (T)this;
    }

    public T right(long expression) {
        this.right = new IntegerOrLongExpression(expression);
        return (T)this;
    }

    public T right(double expression) {
        this.right = new DoubleExpression(expression);
        return (T)this;
    }

    public T right(SQLExpression expression) {
        this.right = expression;
        return (T)this;
    }

    public E build() {
        Preconditions.checkNotNull((Object)this.left, (String)"left expression is null");
        Preconditions.checkNotNull((Object)this.right, (String)"right expression is null");
        Preconditions.checkNotNull(this.supplier, (String)"the supplier is null");
        SQLExpression binaryOperator = (SQLExpression)this.supplier.get();
        if (Strings.isNotEmpty((String)this.operateSymbol)) {
            ((Operator)binaryOperator).setOperateSymbol(this.operateSymbol);
        }
        ((BinaryOperator)binaryOperator).setLeft((Expression)this.left);
        ((BinaryOperator)binaryOperator).setRight((Expression)this.right);
        return (E)binaryOperator;
    }
}

