/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.expression.builder;

import com.jn.langx.el.expression.Expression;
import com.jn.langx.el.expression.operator.Operator;
import com.jn.langx.el.expression.operator.UnaryOperator;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.function.Supplier0;
import com.jn.sqlhelper.dialect.expression.ColumnExpression;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.dialect.expression.StringExpression;
import com.jn.sqlhelper.dialect.expression.builder.SQLExpressionBuilder;

public class UnaryOperatorExpressionBuilder<E extends SQLExpression & UnaryOperator, T extends UnaryOperatorExpressionBuilder<E, T>>
implements SQLExpressionBuilder<E> {
    protected String operateSymbol;
    protected SQLExpression target;
    private Supplier0<E> supplier;

    public T supplier(Supplier0<E> supplier) {
        this.supplier = supplier;
        return (T)this;
    }

    public T operateSymbol(String symbol) {
        this.operateSymbol = symbol;
        return (T)this;
    }

    public T target(SQLExpression expression) {
        this.target = expression;
        return (T)this;
    }

    public T target(String expression) {
        return this.target(expression, false);
    }

    public T target(String expression, boolean isColumn) {
        return this.target(isColumn ? new ColumnExpression(expression) : new StringExpression(expression));
    }

    public E build() {
        Preconditions.checkNotNull((Object)this.target, (String)"the target expression is null");
        Preconditions.checkNotNull(this.supplier, (String)"the supplier is null");
        SQLExpression unaryOperator = (SQLExpression)this.supplier.get();
        if (Strings.isNotEmpty((String)this.operateSymbol)) {
            ((Operator)unaryOperator).setOperateSymbol(this.operateSymbol);
        }
        ((UnaryOperator)unaryOperator).setTarget((Expression)this.target);
        return (E)unaryOperator;
    }
}

