/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.expression.columnevaluation;

import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.dialect.expression.BetweenAndExpression;
import com.jn.sqlhelper.dialect.expression.ColumnExpression;
import com.jn.sqlhelper.dialect.expression.Notable;
import com.jn.sqlhelper.dialect.expression.PlaceholderExpression;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.dialect.expression.builder.BinaryOperatorExpressionBuilder;
import com.jn.sqlhelper.dialect.expression.builder.SQLExpressionBuilder;
import com.jn.sqlhelper.dialect.expression.builder.SQLExpressionBuilders;
import com.jn.sqlhelper.dialect.expression.builder.SQLSymbolExpressionBuilderRegistry;
import com.jn.sqlhelper.dialect.expression.builder.UnaryOperatorExpressionBuilder;
import com.jn.sqlhelper.dialect.expression.columnevaluation.ColumnEvaluation;
import com.jn.sqlhelper.dialect.expression.columnevaluation.ColumnEvaluationExpressionSupplier;

public class BuiltinColumnEvaluationExpressionSupplier
implements ColumnEvaluationExpressionSupplier {
    private SQLSymbolExpressionBuilderRegistry registry;

    public SQLExpression get(ColumnEvaluation columnEvaluation) {
        SQLExpressionBuilder expressionBuilder = this.registry.find(columnEvaluation.getSymbol());
        SQLExpression expression = this.createExpression(expressionBuilder, columnEvaluation);
        if (expression != null && expression instanceof Notable) {
            ((Notable)((Object)expression)).not(columnEvaluation.isNot());
        }
        return expression;
    }

    private SQLExpression createExpression(SQLExpressionBuilder expressionBuilder, ColumnEvaluation columnEvaluation) {
        ColumnExpression columnExpression = new SQLExpressionBuilders.ColumnBuilder().catalog(columnEvaluation.getCatalog()).schema(columnEvaluation.getSchema()).table(columnEvaluation.getTable()).column(columnEvaluation.getColumn()).build();
        if (expressionBuilder instanceof UnaryOperatorExpressionBuilder) {
            UnaryOperatorExpressionBuilder builder = (UnaryOperatorExpressionBuilder)expressionBuilder;
            return ((UnaryOperatorExpressionBuilder)builder.target(columnExpression)).build();
        }
        if (expressionBuilder instanceof BinaryOperatorExpressionBuilder) {
            final BinaryOperatorExpressionBuilder builder = (BinaryOperatorExpressionBuilder)expressionBuilder;
            builder.left(columnExpression);
            Collects.forEach((Iterable)columnEvaluation.getValues(), (Consumer)new Consumer<Object>(){

                public void accept(Object value) {
                    builder.right(new PlaceholderExpression());
                }
            });
            return builder.build();
        }
        if (expressionBuilder instanceof BetweenAndExpression) {
            Preconditions.checkArgument((Objs.length((Object)columnEvaluation.getValues()) == 2 ? 1 : 0) != 0);
            return new SQLExpressionBuilders.BetweenAndBuilder().target(columnExpression).low(new PlaceholderExpression()).high(new PlaceholderExpression()).build();
        }
        return null;
    }

    @Override
    public void setExpressionBuilderRegistry(SQLSymbolExpressionBuilderRegistry registry) {
        this.registry = registry;
    }
}

