/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.instrument;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.annotation.Singleton;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.dialect.instrument.Instrumentation;
import com.jn.sqlhelper.dialect.instrument.Instrumentations;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InstrumentationRegistry
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationRegistry.class);
    private static final InstrumentationRegistry instance = new InstrumentationRegistry();
    private Map<String, Instrumentation> instrumentationMap = Collects.emptyHashMap();
    private Map<String, String> aliasMap = Collects.emptyHashMap();
    private boolean inited = false;

    private InstrumentationRegistry() {
        this.init();
    }

    public void init() throws InitializationException {
        if (!this.inited) {
            this.inited = true;
            ServiceLoader<Instrumentation> loader = ServiceLoader.load(Instrumentation.class);
            Collects.forEach(loader, (Consumer)new Consumer<Instrumentation>(){

                public void accept(Instrumentation instrumentation) {
                    String alias = Instrumentations.getAliasName(instrumentation);
                    String classFullName = Reflects.getFQNClassName(instrumentation.getClass());
                    if (Objs.isNotEmpty((Object)alias)) {
                        InstrumentationRegistry.this.aliasMap.put(alias, classFullName);
                    }
                    InstrumentationRegistry.this.instrumentationMap.put(classFullName, instrumentation);
                    instrumentation.init();
                }
            });
        }
    }

    public static InstrumentationRegistry getInstance() {
        return instance;
    }

    public void enableInstrumentation(@NonNull String name) {
        if (Objs.isNotEmpty((Object)name)) {
            logger.info("Start to enable SQL instrumentation: {}", (Object)name);
            Instrumentation instrumentation = this.findInstrumentation(name, false);
            if (instrumentation != null) {
                instrumentation.setEnabled(true);
            }
        }
    }

    public Instrumentation findInstrumentation(@Nullable String name) {
        return this.findInstrumentation(name, true);
    }

    private Instrumentation findInstrumentation(@Nullable String name, final boolean enabled) {
        Instrumentation instrumentation;
        if (name == null) {
            return (Instrumentation)Collects.findFirst(this.instrumentationMap.values(), (Predicate)new Predicate<Instrumentation>(){

                public boolean test(Instrumentation instrumentation) {
                    return !enabled || instrumentation.isEnabled();
                }
            });
        }
        String className = this.aliasMap.get(name);
        if (className == null) {
            className = name;
        }
        if ((instrumentation = this.instrumentationMap.get(className)) == null) {
            return null;
        }
        if (enabled && !instrumentation.isEnabled()) {
            return null;
        }
        return instrumentation;
    }
}

