/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.instrument.orderby;

import com.jn.sqlhelper.dialect.instrument.AbstractClauseTransformer;
import com.jn.sqlhelper.dialect.instrument.TransformConfig;
import com.jn.sqlhelper.dialect.instrument.orderby.OrderByTransformer;
import com.jn.sqlhelper.dialect.instrument.orderby.SimpleOrderByTransformer;
import com.jn.sqlhelper.dialect.sqlparser.SqlStatementWrapper;
import com.jn.sqlhelper.dialect.sqlparser.StringSqlStatementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOrderByTransformer
extends AbstractClauseTransformer
implements OrderByTransformer {
    private final SimpleOrderByTransformer simpleTransformer = new SimpleOrderByTransformer();
    private static final Logger logger = LoggerFactory.getLogger(DefaultOrderByTransformer.class);

    @Override
    protected void doInit() {
    }

    @Override
    public SqlStatementWrapper transform(SqlStatementWrapper statement, TransformConfig config) {
        OrderByTransformer orderByTransformer = null;
        try {
            orderByTransformer = this.getInstrumentation().getOrderByTransformer();
            if (orderByTransformer != null) {
                return orderByTransformer.transform(statement, config);
            }
        }
        catch (Throwable ex) {
            logger.debug(ex.getMessage(), ex);
        }
        if (!this.simpleTransformer.isTransformable(statement)) {
            StringSqlStatementWrapper sw = new StringSqlStatementWrapper();
            sw.setOriginalSql(statement.getOriginalSql());
            sw.setChanged(statement.isChanged());
            sw.setStatement(statement.getSql());
            return this.simpleTransformer.transform(sw, config);
        }
        return this.simpleTransformer.transform(statement, config);
    }
}

