/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.LimitCommaLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitOffsetLimitHandler;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import java.util.HashMap;
import java.util.Map;

public class AuroraDialect
extends AbstractDialect {
    private WorkingWith workingWith;
    private static final Map<WorkingWith, LimitHandler> limitHandlerMap = new HashMap<WorkingWith, LimitHandler>();
    private static final Map<WorkingWith, LikeEscaper> likeEscaperMap = new HashMap<WorkingWith, LikeEscaper>();

    public AuroraDialect() {
        if (AuroraDialect.findMySQLDriver()) {
            this.workingWith = WorkingWith.MySQL;
        } else if (AuroraDialect.findPostgreSQLDriver()) {
            this.workingWith = WorkingWith.PostgreSQL;
        }
        this.setLimitHandler(limitHandlerMap.get((Object)this.workingWith));
    }

    private static boolean findMySQLDriver() {
        return true;
    }

    private static boolean findPostgreSQLDriver() {
        return false;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        boolean reverse = false;
        switch (this.workingWith) {
            case MySQL: {
                reverse = false;
                break;
            }
            case PostgreSQL: {
                reverse = true;
                break;
            }
            default: {
                reverse = false;
            }
        }
        return reverse;
    }

    static {
        limitHandlerMap.put(WorkingWith.MySQL, new LimitCommaLimitHandler());
        limitHandlerMap.put(WorkingWith.PostgreSQL, new LimitOffsetLimitHandler());
    }

    static enum WorkingWith {
        MySQL,
        PostgreSQL;

    }
}

