/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class DB2Dialect
extends AbstractDialect {
    public DB2Dialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection selection) {
                if (DB2Dialect.this.isDB2_400OrNewer()) {
                    if (LimitHelper.hasFirstRow(selection)) {
                        return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( " + sql + " fetch first " + this.getMaxOrLimit(selection) + " rows only ) as inner2_ ) as inner1_ where rownumber_ > " + selection.getOffset() + " order by rownumber_";
                    }
                    return sql + " fetch first " + this.getMaxOrLimit(selection) + " rows only";
                }
                int limit = selection.getLimit();
                if (limit == 0) {
                    return sql;
                }
                return sql + " fetch first " + limit + " rows only ";
            }
        });
        this.setPlainSqlScriptParser(new DB2SqlScriptParser());
    }

    private boolean isDB2_400OrNewer() {
        return true;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsVariableLimit() {
        return false;
    }

    @Override
    public boolean isUseMaxForLimit() {
        return true;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    private static class DB2ZosSqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private boolean insideBeginEndBlock;
        private String statementStart = "";

        private DB2ZosSqlStatementBuilder() {
        }

        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (Strings.countOccurrencesOf((String)this.statementStart, (String)" ") < 4) {
                this.statementStart = this.statementStart + line;
                this.statementStart = this.statementStart + " ";
            }
            if (this.statementStart.startsWith("CREATE FUNCTION") || this.statementStart.startsWith("CREATE PROCEDURE") || this.statementStart.startsWith("CREATE TRIGGER") || this.statementStart.startsWith("CREATE OR REPLACE FUNCTION") || this.statementStart.startsWith("CREATE OR REPLACE PROCEDURE") || this.statementStart.startsWith("CREATE OR REPLACE TRIGGER")) {
                if (line.startsWith("BEGIN")) {
                    this.insideBeginEndBlock = true;
                }
                if (line.endsWith("END;")) {
                    this.insideBeginEndBlock = false;
                }
            }
            if (this.insideBeginEndBlock) {
                return null;
            }
            return this.getDefaultDelimiter();
        }
    }

    private static class DB2SqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private boolean insideBeginEndBlock;
        private String statementStart = "";

        private DB2SqlStatementBuilder() {
        }

        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (Strings.countOccurrencesOf((String)this.statementStart, (String)" ") < 4) {
                this.statementStart = this.statementStart + line;
                this.statementStart = this.statementStart + " ";
            }
            if (this.statementStart.startsWith("CREATE FUNCTION") || this.statementStart.startsWith("CREATE PROCEDURE") || this.statementStart.startsWith("CREATE TRIGGER") || this.statementStart.startsWith("CREATE OR REPLACE FUNCTION") || this.statementStart.startsWith("CREATE OR REPLACE PROCEDURE") || this.statementStart.startsWith("CREATE OR REPLACE TRIGGER")) {
                if (line.startsWith("BEGIN")) {
                    this.insideBeginEndBlock = true;
                }
                if (line.endsWith("END;")) {
                    this.insideBeginEndBlock = false;
                }
            }
            if (this.insideBeginEndBlock) {
                return null;
            }
            return this.getDefaultDelimiter();
        }
    }

    private static class DB2SqlScriptParser
    extends PlainSqlScriptParser {
        private DB2SqlScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new DB2SqlStatementBuilder();
        }
    }
}

