/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class GreenplumDialect
extends AbstractDialect {
    public GreenplumDialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection rowSelection) {
                return this.getLimitString(sql, LimitHelper.hasFirstRow(rowSelection));
            }

            @Override
            protected String getLimitString(String sql, boolean hasOffset) {
                int forShareIndex;
                sql = sql.trim();
                String forUpdateClause = null;
                boolean isForUpdate = false;
                int forUpdateIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for update");
                if (forUpdateIndex > -1) {
                    forUpdateClause = sql.substring(forUpdateIndex);
                    sql = sql.substring(0, forUpdateIndex - 1);
                    isForUpdate = true;
                }
                String forShareClause = null;
                boolean isForShare = false;
                if (!isForUpdate && (forShareIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for share")) > -1) {
                    forShareClause = sql.substring(forShareIndex);
                    sql = sql.substring(0, forShareIndex - 1);
                    isForShare = true;
                }
                StringBuilder sql2 = new StringBuilder(sql.length() + 100);
                sql2.append(sql);
                if (hasOffset) {
                    sql2.append(" LIMIT ? OFFSET ? ");
                } else {
                    sql2.append(" LIMIT ?  ");
                }
                if (isForUpdate) {
                    sql2.append(forUpdateClause);
                }
                if (isForShare) {
                    sql2.append(forShareClause);
                }
                return sql2.toString();
            }
        });
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return true;
    }
}

