/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.LimitOffsetLimitHandler;
import com.jn.sqlhelper.dialect.likeescaper.BackslashStyleEscaper;

public class H2Dialect
extends AbstractDialect {
    public H2Dialect() {
        this.setLimitHandler(new LimitOffsetLimitHandler());
        this.setLikeEscaper(new BackslashStyleEscaper());
        this.setPlainSqlScriptParser(new H2SqlScriptParser());
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return true;
    }

    private static class H2SqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private H2SqlStatementBuilder() {
        }

        protected String extractAlternateOpenQuote(String token) {
            if (token.startsWith("$$")) {
                return "$$";
            }
            return null;
        }
    }

    private static class H2SqlScriptParser
    extends PlainSqlScriptParser {
        private H2SqlScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new PlainSqlStatementBuilder();
        }
    }
}

