/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.annotation.Name;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.OffsetFetchFirstOnlyLimitHandler;

@Name(value="hsql")
public class HSQLDialect
extends AbstractDialect {
    public HSQLDialect() {
        this.setLimitHandler(new OffsetFetchFirstOnlyLimitHandler().setSupportUsingIndexClauseInSelectEnd(true));
        this.setPlainSqlScriptParser(new HSQLSqlScriptParser());
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersFirst() {
        return false;
    }

    private static class HsqlSqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private boolean insideAtomicBlock;

        private HsqlSqlStatementBuilder() {
        }

        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (line.contains("BEGIN ATOMIC")) {
                this.insideAtomicBlock = true;
            }
            if (line.endsWith("END;")) {
                this.insideAtomicBlock = false;
            }
            if (this.insideAtomicBlock) {
                return null;
            }
            return this.getDefaultDelimiter();
        }
    }

    private static class HSQLSqlScriptParser
    extends PlainSqlScriptParser {
        private HSQLSqlScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new HsqlSqlStatementBuilder();
        }
    }
}

