/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.annotation.Name;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.LimitOnlyLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.SkipLimitHandler;
import com.jn.sqlhelper.dialect.internal.urlparser.InformixUrlParser;
import java.sql.Driver;

@Name(value="informix")
@com.jn.sqlhelper.dialect.annotation.Driver(value={"com.informix.jdbc.IfxDriver"})
public class InformixDialect
extends AbstractDialect {
    public InformixDialect() {
        this.setDelegate(new Informix10Dialect());
        this.setUrlParser(new InformixUrlParser());
    }

    public InformixDialect(Driver driver) {
        if (driver.getMajorVersion() >= 4) {
            this.setDelegate(new Informix10Dialect());
        } else {
            this.setDelegate(new Informix9Dialect());
        }
        this.setUrlParser(new InformixUrlParser());
    }

    @Override
    public boolean isSupportsLimit() {
        return this.getRealDialect().isSupportsLimit();
    }

    @Override
    public boolean isUseMaxForLimit() {
        return this.getRealDialect().isUseMaxForLimit();
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return this.getRealDialect().isSupportsLimitOffset();
    }

    @Override
    public boolean isSupportsVariableLimit() {
        return this.getRealDialect().isSupportsVariableLimit();
    }

    static class Informix10Dialect
    extends AbstractDialect {
        public Informix10Dialect() {
            this.setLimitHandler(new SkipLimitHandler());
        }

        @Override
        public boolean isSupportsLimit() {
            return true;
        }

        @Override
        public boolean isSupportsLimitOffset() {
            return true;
        }

        @Override
        public boolean isSupportsVariableLimit() {
            return false;
        }

        @Override
        public boolean isBindLimitParametersFirst() {
            return true;
        }
    }

    static class Informix9Dialect
    extends AbstractDialect {
        public Informix9Dialect() {
            this.setLimitHandler(new LimitOnlyLimitHandler());
        }

        @Override
        public boolean isSupportsLimit() {
            return true;
        }

        @Override
        public boolean isUseMaxForLimit() {
            return true;
        }

        @Override
        public boolean isSupportsLimitOffset() {
            return false;
        }

        @Override
        public boolean isSupportsVariableLimit() {
            return false;
        }

        @Override
        public boolean isBindLimitParametersFirst() {
            return true;
        }
    }
}

