/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class MemSQLDialect
extends AbstractDialect {
    public MemSQLDialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection rowSelection) {
                return this.getLimitString(sql, LimitHelper.hasFirstRow(rowSelection));
            }

            @Override
            protected String getLimitString(String sql, boolean hasOffset) {
                int forUpdateIndex;
                int intoIndex;
                sql = sql.trim();
                String intoOutfileClause = null;
                boolean isIntoOutfile = false;
                int intoOutfileIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("into outfile");
                if (intoOutfileIndex > -1) {
                    intoOutfileClause = sql.substring(intoOutfileIndex);
                    sql = sql.substring(0, intoOutfileIndex - 1);
                    isIntoOutfile = true;
                }
                String intoClause = null;
                boolean isInto = false;
                if (!isIntoOutfile && (intoIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("into")) > -1) {
                    intoClause = sql.substring(intoIndex);
                    sql = sql.substring(0, intoIndex - 1);
                    isInto = true;
                }
                String forUpdateClause = null;
                boolean isForUpdate = false;
                if (!isInto && (forUpdateIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for update")) > -1) {
                    forUpdateClause = sql.substring(forUpdateIndex);
                    sql = sql.substring(0, forUpdateIndex - 1);
                    isForUpdate = true;
                }
                StringBuilder sql2 = new StringBuilder(sql.length() + 100);
                sql2.append(sql);
                if (hasOffset) {
                    sql2.append(" limit ?, ? ");
                } else {
                    sql2.append(" limit ? ");
                }
                if (isIntoOutfile) {
                    sql2.append(intoOutfileClause);
                } else if (isInto) {
                    sql2.append(intoClause);
                } else if (isForUpdate) {
                    sql2.append(forUpdateClause);
                }
                return sql2.toString();
            }
        });
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return false;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }
}

