/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.pagination.RowSelection;

public class MonetDialect
extends AbstractDialect {
    private static final Regexp SAMPLE_SQL_PATTERN = Regexps.createRegexp((String)".* sample\\w+(\\d+|\\?)$");

    public MonetDialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection rowSelection) {
                return this.getLimitString(sql, rowSelection.getOffset() > 0L);
            }

            @Override
            protected String getLimitString(String sql, boolean hasOffset) {
                sql = sql.trim();
                while (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                String lowercaseSql = sql.toLowerCase();
                boolean hasSampleClause = false;
                String sampleSql = null;
                if (SAMPLE_SQL_PATTERN.matcher((CharSequence)lowercaseSql).matches()) {
                    hasSampleClause = true;
                    int lastIndex = lowercaseSql.lastIndexOf("sample");
                    sampleSql = " " + sql.substring(lastIndex);
                    sql = sql.substring(0, lastIndex);
                }
                sql = sql + (hasOffset ? " limit ? offset ? " : " limit ? ") + (hasSampleClause ? sampleSql : "");
                return sql;
            }
        });
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return true;
    }
}

