/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.LimitCommaLimitHandler;
import com.jn.sqlhelper.dialect.internal.urlparser.MySqlUrlParser;
import com.jn.sqlhelper.dialect.likeescaper.BackslashStyleEscaper;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class MySQLDialect
extends AbstractDialect {
    public MySQLDialect() {
        this.setUrlParser(new MySqlUrlParser());
        this.setLimitHandler(new LimitCommaLimitHandler());
        this.setLikeEscaper(BackslashStyleEscaper.INSTANCE);
        this.setPlainSqlScriptParser(new MySQLScriptParser());
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public char getBeforeQuote() {
        return '`';
    }

    @Override
    public char getAfterQuote() {
        return '`';
    }

    @Override
    public boolean isSupportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean isSupportsBatchSql() {
        return true;
    }

    private static class MySQLSqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private static final String DELIMITER_KEYWORD = "DELIMITER";
        private final String[] charSets = new String[]{"ARMSCII8", "ASCII", "BIG5", "BINARY", "CP1250", "CP1251", "CP1256", "CP1257", "CP850", "CP852", "CP866", "CP932", "DEC8", "EUCJPMS", "EUCKR", "GB2312", "GBK", "GEOSTD8", "GREEK", "HEBREW", "HP8", "KEYBCS2", "KOI8R", "KOI8U", "LATIN1", "LATIN2", "LATIN5", "LATIN7", "MACCE", "MACROMAN", "SJIS", "SWE7", "TIS620", "UCS2", "UJIS", "UTF8"};
        boolean isInMultiLineCommentDirective = false;

        private MySQLSqlStatementBuilder() {
        }

        public PlainSqlDelimiter extractNewDelimiterFromLine(String line) {
            if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
                return new PlainSqlDelimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
            }
            return null;
        }

        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
                return new PlainSqlDelimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
            }
            return delimiter;
        }

        public boolean isCommentDirective(String line) {
            if (line.matches("^" + Pattern.quote("/*!") + "\\d{5} .*" + Pattern.quote("*/") + "\\s*;?")) {
                return true;
            }
            if (this.isInMultiLineCommentDirective && line.matches(".*" + Pattern.quote("*/") + "\\s*;?")) {
                this.isInMultiLineCommentDirective = false;
                return true;
            }
            if (line.matches("^" + Pattern.quote("/*!") + "\\d{5} .*")) {
                this.isInMultiLineCommentDirective = true;
                return true;
            }
            return this.isInMultiLineCommentDirective;
        }

        protected boolean isSingleLineComment(String line) {
            return line.startsWith("--") || line.startsWith("#");
        }

        protected String removeEscapedQuotes(String token) {
            String noEscapedBackslashes = Strings.replace((String)token, (String)"\\\\", (String)"");
            String noBackslashEscapes = Strings.replace((String)Strings.replace((String)noEscapedBackslashes, (String)"\\'", (String)""), (String)"\\\"", (String)"");
            return Strings.replace((String)noBackslashEscapes, (String)"''", (String)"").replace("'", " ' ");
        }

        protected String cleanToken(String token) {
            if (token.startsWith("_")) {
                for (String charSet : this.charSets) {
                    String cast = "_" + charSet;
                    if (!token.startsWith(cast)) continue;
                    return token.substring(cast.length());
                }
            }
            return token;
        }

        protected String extractAlternateOpenQuote(String token) {
            if (token.startsWith("\"")) {
                return "\"";
            }
            if (token.startsWith("B'") && token.length() > 2) {
                return "B'";
            }
            if (token.startsWith("X'") && token.length() > 2) {
                return "X'";
            }
            return null;
        }

        protected String computeAlternateCloseQuote(String openQuote) {
            if ("B'".equals(openQuote) || "X'".equals(openQuote)) {
                return "'";
            }
            return openQuote;
        }
    }

    private static class MySQLScriptParser
    extends PlainSqlScriptParser {
        private MySQLScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new MySQLSqlStatementBuilder();
        }
    }
}

