/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.SQLDialectException;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.internal.limit.OracleXLimitHandler;
import com.jn.sqlhelper.dialect.internal.urlparser.OracleUrlParser;
import com.jn.sqlhelper.dialect.likeescaper.BackslashStyleEscaper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.sql.CallableStatement;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.jn.sqlhelper.dialect.annotation.Driver(value={"oracle.jdbc.driver.OracleDriver"})
public class OracleDialect
extends AbstractDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 1000;

    public OracleDialect() {
        this.setDelegate(new Oracle9iDialect());
        this.setUrlParser(new OracleUrlParser());
        this.setLikeEscaper(BackslashStyleEscaper.NON_DEFAULT_INSTANCE);
        this.setPlainSqlScriptParser(new OracleSqlScriptParser());
    }

    public OracleDialect(Driver driver) {
        int majorVersion = driver.getMajorVersion();
        int minorVersion = driver.getMinorVersion();
        if (majorVersion < 9) {
            this.setDelegate(new Oracle8iDialect());
            return;
        }
        if (majorVersion == 9) {
            this.setDelegate(new Oracle9iDialect());
            return;
        }
        if (majorVersion == 10) {
            if (minorVersion < 3) {
                this.setDelegate(new Oracle10gDialect());
                return;
            }
            this.setDelegate(new Oracle11gDialect());
            return;
        }
        if (majorVersion >= 12) {
            this.setDelegate(new Oracle12cDialect());
            return;
        }
        this.setDelegate(new Oracle9Dialect());
        this.setUrlParser(new OracleUrlParser());
        this.setLikeEscaper(BackslashStyleEscaper.NON_DEFAULT_INSTANCE);
        this.setPlainSqlScriptParser(new OracleSqlScriptParser());
    }

    private static class OracleSqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private static final Pattern KEYWORDS_BEFORE_STRING_LITERAL_REGEX = Pattern.compile("^(N|IF|ELSIF|SELECT|IMMEDIATE|RETURN|IS)('.*)");
        private static final Pattern KEYWORDS_AFTER_STRING_LITERAL_REGEX = Pattern.compile("(.*')(USING|THEN|FROM)");
        private static final PlainSqlDelimiter PLSQL_DELIMITER = new PlainSqlDelimiter("/", true);
        private String statementStart = "";

        private OracleSqlStatementBuilder() {
        }

        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (line.matches("DECLARE|DECLARE\\s.*") || line.matches("BEGIN|BEGIN\\s.*")) {
                return PLSQL_DELIMITER;
            }
            if (Strings.countOccurrencesOf((String)this.statementStart, (String)" ") < 8) {
                this.statementStart = this.statementStart + line;
                this.statementStart = this.statementStart + " ";
                this.statementStart = this.statementStart.replaceAll("\\s+", " ");
            }
            if (this.statementStart.matches("CREATE( OR REPLACE)? (FUNCTION|PROCEDURE|PACKAGE|TYPE|TRIGGER).*") || this.statementStart.matches("CREATE( OR REPLACE)?( AND (RESOLVE|COMPILE))?( NOFORCE)? JAVA (SOURCE|RESOURCE|CLASS).*")) {
                return PLSQL_DELIMITER;
            }
            return delimiter;
        }

        protected String cleanToken(String token) {
            Matcher afterMatcher;
            Matcher beforeMatcher = KEYWORDS_BEFORE_STRING_LITERAL_REGEX.matcher(token);
            if (beforeMatcher.find()) {
                token = beforeMatcher.group(2);
            }
            if ((afterMatcher = KEYWORDS_AFTER_STRING_LITERAL_REGEX.matcher(token)).find()) {
                token = afterMatcher.group(1);
            }
            return token;
        }

        protected String simplifyLine(String line) {
            String simplifiedQQuotes = Strings.replace((String)Strings.replace((String)line, (String)"q'(", (String)"q'["), (String)")'", (String)"]'");
            return super.simplifyLine(simplifiedQQuotes);
        }

        protected String extractAlternateOpenQuote(String token) {
            if (token.startsWith("Q'") && token.length() >= 3) {
                return token.substring(0, 3);
            }
            return null;
        }

        protected String computeAlternateCloseQuote(String openQuote) {
            char specialChar = openQuote.charAt(2);
            switch (specialChar) {
                case '[': {
                    return "]'";
                }
                case '(': {
                    return ")'";
                }
                case '{': {
                    return "}'";
                }
                case '<': {
                    return ">'";
                }
            }
            return specialChar + "'";
        }
    }

    private static class OracleSqlScriptParser
    extends PlainSqlScriptParser {
        private OracleSqlScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new OracleSqlStatementBuilder();
        }
    }

    private static class OracleTypesHelper {
        private static final Logger log = LoggerFactory.getLogger(OracleTypesHelper.class);
        public static final OracleTypesHelper INSTANCE = new OracleTypesHelper();
        private static final String ORACLE_TYPES_CLASS_NAME = "oracle.jdbc.OracleTypes";
        private static final String DEPRECATED_ORACLE_TYPES_CLASS_NAME = "oracle.jdbc.driver.OracleTypes";
        private final int oracleCursorTypeSqlType;

        private OracleTypesHelper() {
            int typeCode = -99;
            try {
                typeCode = this.extractOracleCursorTypeValue();
            }
            catch (Exception e) {
                log.warn("Unable to resolve Oracle CURSOR JDBC type code", (Throwable)e);
            }
            this.oracleCursorTypeSqlType = typeCode;
        }

        private int extractOracleCursorTypeValue() {
            try {
                return this.locateOracleTypesClass().getField("CURSOR").getInt(null);
            }
            catch (Exception se) {
                throw new SQLDialectException("Unable to access OracleTypes.CURSOR value", se);
            }
        }

        private Class locateOracleTypesClass() {
            try {
                return Class.forName(ORACLE_TYPES_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                try {
                    return Class.forName(DEPRECATED_ORACLE_TYPES_CLASS_NAME);
                }
                catch (ClassNotFoundException e2) {
                    throw new SQLDialectException(String.format("Unable to locate OracleTypes class using either known FQN [%s, %s]", ORACLE_TYPES_CLASS_NAME, DEPRECATED_ORACLE_TYPES_CLASS_NAME), e);
                }
            }
        }

        public int getOracleCursorTypeSqlType() {
            return this.oracleCursorTypeSqlType;
        }
    }

    private class Oracle12cDialect
    extends Oracle11gDialect {
        private Oracle12cDialect() {
        }
    }

    private class Oracle11gDialect
    extends Oracle10gDialect {
        private Oracle11gDialect() {
        }
    }

    private class Oracle10gDialect
    extends Oracle9iDialect {
        private Oracle10gDialect() {
        }
    }

    private class Oracle9iDialect
    extends OracleBaseDialect {
        private Oracle9iDialect() {
            this.setLimitHandler(new OracleXLimitHandler());
        }
    }

    private class Oracle9Dialect
    extends OracleBaseDialect {
        private Oracle9Dialect() {
            this.setLimitHandler(new Oracle8i9LimitHandler());
        }
    }

    private class Oracle8iDialect
    extends OracleBaseDialect {
        private Oracle8iDialect() {
            this.setLimitHandler(new Oracle8i9LimitHandler());
        }
    }

    private static class Oracle8i9LimitHandler
    extends AbstractLimitHandler {
        private Oracle8i9LimitHandler() {
        }

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            return this.getLimitString(sql, hasOffset);
        }

        @Override
        public String getLimitString(String sql, boolean hasOffset) {
            sql = sql.trim();
            boolean isForUpdate = false;
            if (sql.toLowerCase(Locale.ROOT).endsWith(" for update")) {
                sql = sql.substring(0, sql.length() - 11);
                isForUpdate = true;
            }
            StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
            if (hasOffset) {
                pagingSelect.append("select * from ( select sqlhelper_rowtable_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (hasOffset) {
                pagingSelect.append(" ) sqlhelper_rowtable_ ) where rownum_ <= ? and rownum_ > ?");
            } else {
                pagingSelect.append(" ) sqlhelper_rowtable_ where rownum <= ?");
            }
            if (isForUpdate) {
                pagingSelect.append(" for update");
            }
            return pagingSelect.toString();
        }
    }

    class OracleBaseDialect
    extends AbstractDialect {
        OracleBaseDialect() {
            this.setLikeEscaper(BackslashStyleEscaper.NON_DEFAULT_INSTANCE);
            this.setUrlParser(new OracleUrlParser());
            this.setPlainSqlScriptParser(new OracleSqlScriptParser());
        }

        @Override
        public boolean isSupportsLimit() {
            return true;
        }

        @Override
        public boolean isBindLimitParametersInReverseOrder() {
            return true;
        }

        @Override
        public boolean isUseMaxForLimit() {
            return true;
        }

        @Override
        public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
            statement.registerOutParameter(col, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
            return ++col;
        }

        @Override
        public boolean isSupportsBatchUpdates() {
            return true;
        }

        @Override
        public boolean isSupportsBatchSql() {
            return true;
        }
    }
}

