/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.LimitOffsetLimitHandler;
import com.jn.sqlhelper.dialect.likeescaper.BackslashStyleEscaper;

public class SQLiteDialect
extends AbstractDialect {
    public SQLiteDialect() {
        this.setLimitHandler(new LimitOffsetLimitHandler());
        this.setLikeEscaper(BackslashStyleEscaper.NON_DEFAULT_INSTANCE);
        this.setPlainSqlScriptParser(new SQLiteSqlScriptParser());
    }

    @Override
    public char getBeforeQuote() {
        return '`';
    }

    @Override
    public char getAfterQuote() {
        return '`';
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return true;
    }

    private static class SQLiteSqlStatementBuilder
    extends PlainSqlStatementBuilder {
        private boolean insideBeginEndBlock;

        private SQLiteSqlStatementBuilder() {
        }

        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (line.contains("BEGIN")) {
                this.insideBeginEndBlock = true;
            }
            if (line.endsWith("END;")) {
                this.insideBeginEndBlock = false;
            }
            if (this.insideBeginEndBlock) {
                return null;
            }
            return this.getDefaultDelimiter();
        }
    }

    private static class SQLiteSqlScriptParser
    extends PlainSqlScriptParser {
        private SQLiteSqlScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new SQLiteSqlStatementBuilder();
        }
    }
}

