/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlScriptParser;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.internal.sqlscript.PostgreSQLSqlStatementBuilder;
import com.jn.sqlhelper.dialect.pagination.RowSelection;

public class VerticaDialect
extends AbstractDialect {
    public VerticaDialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection rowSelection) {
                return this.getLimitString(sql, LimitHelper.hasFirstRow(rowSelection));
            }

            @Override
            protected String getLimitString(String sql, boolean hasOffset) {
                return sql + " limit ?";
            }
        });
        this.setPlainSqlScriptParser(new VerticaSqlScriptParser());
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return false;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    private static class VerticaStatementBuilder
    extends PostgreSQLSqlStatementBuilder {
        private boolean insideBeginEndBlock;
        private String statementStart = "";

        private VerticaStatementBuilder() {
        }

        @Override
        protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
            if (Strings.countOccurrencesOf((String)this.statementStart, (String)" ") < 4) {
                this.statementStart = this.statementStart + line;
                this.statementStart = this.statementStart + " ";
            }
            if (this.statementStart.startsWith("CREATE FUNCTION")) {
                if (line.startsWith("BEGIN") || line.endsWith("BEGIN")) {
                    this.insideBeginEndBlock = true;
                }
                if (line.endsWith("END;")) {
                    this.insideBeginEndBlock = false;
                }
            }
            if (this.insideBeginEndBlock) {
                return null;
            }
            return this.getDefaultDelimiter();
        }
    }

    private static class VerticaSqlScriptParser
    extends PlainSqlScriptParser {
        private VerticaSqlScriptParser() {
        }

        protected PlainSqlStatementBuilder newSqlStatementBuilder() {
            return new VerticaStatementBuilder();
        }
    }
}

