/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class FirstOrderLimitHandler
extends AbstractLimitHandler {
    @Override
    public String processSql(String sql, RowSelection rowSelection) {
        return this.getLimitString(sql, LimitHelper.getFirstRow(rowSelection), this.getMaxOrLimit(rowSelection));
    }

    @Override
    protected String getLimitString(String sql, long offset, int limit) {
        boolean hasOffset = offset > 0L;
        sql = sql.trim();
        boolean hasOrderByClause = false;
        String orderByClause = null;
        String sqlLowercase = sql.toLowerCase(Locale.ROOT);
        int orderByIndex = sqlLowercase.lastIndexOf("order by");
        if (orderByIndex > -1) {
            orderByClause = sql.substring(orderByIndex);
            sql = sql.substring(0, orderByIndex - 1);
            hasOrderByClause = true;
        }
        StringBuilder sql2 = new StringBuilder(sql.length() + 100);
        sql2.append(sql);
        if (this.getDialect().isUseLimitInVariableMode()) {
            if (hasOffset) {
                sql2.append(" FIRST ? TO ? ");
            } else {
                sql2.append(" FIRST ? ");
            }
        } else if (hasOffset) {
            sql2.append(" FIRST " + offset + " TO " + limit + " ");
        } else {
            sql2.append(" FIRST " + limit + " ");
        }
        if (hasOrderByClause) {
            sql2.append(orderByClause);
        }
        return sql2.toString();
    }
}

