/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class LimitCommaLimitHandler
extends AbstractLimitHandler {
    private boolean isSupportForUpdate;
    private boolean withBrace = false;
    private int offsetBased = 0;

    @Override
    public String processSql(String sql, RowSelection rowSelection) {
        return this.getLimitString(sql, LimitHelper.getFirstRow(rowSelection), this.getMaxOrLimit(rowSelection));
    }

    @Override
    protected String getLimitString(String sql, long offset, int limit) {
        String sqlLowercase;
        int forUpdateIndex;
        boolean hasOffset = offset > 0L;
        sql = sql.trim();
        String forUpdateClause = "";
        boolean isForUpdate = false;
        if (this.isSupportForUpdate() && (forUpdateIndex = (sqlLowercase = sql.toLowerCase(Locale.ROOT)).lastIndexOf("for update")) > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        StringBuilder sql2 = new StringBuilder(sql.length() + 100);
        sql2.append(sql);
        if (this.getDialect().isUseLimitInVariableMode()) {
            if (this.withBrace) {
                sql2.append(hasOffset ? " limit (?, ?)" : " limit ?");
            } else {
                sql2.append(hasOffset ? " limit ?, ?" : " limit ?");
            }
        } else if (this.withBrace) {
            sql2.append(hasOffset ? " limit (" + offset + ", " + limit + ")" : " limit " + limit);
        } else {
            sql2.append(hasOffset ? " limit " + offset + ", " + limit : " limit " + limit);
        }
        if (isForUpdate) {
            sql2.append(" " + forUpdateClause);
        }
        return sql2.toString();
    }

    public boolean isSupportForUpdate() {
        return this.isSupportForUpdate;
    }

    public LimitCommaLimitHandler setSupportForUpdate(boolean supportForUpdate) {
        this.isSupportForUpdate = supportForUpdate;
        return this;
    }

    public boolean isWithBrace() {
        return this.withBrace;
    }

    public LimitCommaLimitHandler setWithBrace(boolean withBrace) {
        this.withBrace = withBrace;
        return this;
    }

    public int getOffsetBased() {
        return this.offsetBased;
    }

    @Override
    public void setOffsetBased(int offsetBased) {
        this.offsetBased = offsetBased;
    }
}

