/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class SkipLimitHandler
extends AbstractLimitHandler {
    private String firstNKeyword = "FIRST";

    public SkipLimitHandler() {
        this("FIRST");
    }

    public SkipLimitHandler(String firstNKeyword) {
        this.firstNKeyword = firstNKeyword;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        boolean hasOffset = LimitHelper.hasFirstRow(selection);
        String sqlLimit = "";
        if (hasOffset) {
            sqlLimit = this.getDialect().isSupportsVariableLimit() ? " SKIP ? " : " SKIP " + selection.getOffset();
        }
        sqlLimit = this.getDialect().isSupportsVariableLimit() ? sqlLimit + " " + this.firstNKeyword + " ? " : sqlLimit + " " + this.firstNKeyword + " " + this.getMaxOrLimit(selection) + " ";
        return new StringBuilder(sql.length() + 10).append(sql).insert(sql.toLowerCase(Locale.ROOT).indexOf("select") + 6, sqlLimit).toString();
    }
}

