/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class TopLimitHandler
extends AbstractLimitHandler {
    private static final String SELECT_LOWERCASE = "select";
    private static final String SELECT_DISTINCT_LOWERCASE = "select distinct";
    private static final String SELECT_ALL_LOWERCASE = "select all";
    private boolean useSkipTop = false;

    @Override
    public String processSql(String sql, RowSelection rowSelection) {
        return this.getLimitString(sql, LimitHelper.getFirstRow(rowSelection), this.getMaxOrLimit(rowSelection));
    }

    @Override
    protected String getLimitString(String sql, long offset, int limit) {
        boolean hasOffset = offset > 0L;
        sql = sql.trim();
        String sqlLowercase = sql.toLowerCase(Locale.ROOT);
        int selectIndex = sqlLowercase.indexOf(SELECT_LOWERCASE);
        int selectDistinctIndex = sqlLowercase.indexOf(SELECT_DISTINCT_LOWERCASE);
        int selectAllIndex = sqlLowercase.indexOf(SELECT_ALL_LOWERCASE);
        int insertionPoint = -1;
        if (selectDistinctIndex != -1) {
            insertionPoint = selectDistinctIndex + SELECT_DISTINCT_LOWERCASE.length();
        } else if (selectAllIndex != -1) {
            insertionPoint = selectAllIndex + SELECT_ALL_LOWERCASE.length();
        } else if (selectIndex != -1) {
            insertionPoint = selectIndex + SELECT_LOWERCASE.length();
        } else {
            return sql;
        }
        if (insertionPoint < 0) {
            return sql;
        }
        StringBuilder sql2 = new StringBuilder(sql.length() + 50).append(sql);
        if (this.getDialect().isUseLimitInVariableMode()) {
            if (this.getDialect().isSupportsLimitOffset() && hasOffset) {
                if (!this.isUseSkipTop()) {
                    sql2.insert(insertionPoint, " TOP ?, ? ");
                } else {
                    sql2.insert(insertionPoint, " SKIP ? TOP ? ");
                }
            } else {
                sql2.insert(insertionPoint, " TOP ? ");
            }
        } else if (this.getDialect().isSupportsLimitOffset() && hasOffset) {
            if (!this.isUseSkipTop()) {
                if (this.getDialect().isBindLimitParametersInReverseOrder()) {
                    sql2.insert(insertionPoint, " TOP " + limit + ", " + offset + " ");
                } else {
                    sql2.insert(insertionPoint, " TOP " + offset + ", " + limit + " ");
                }
            } else {
                sql2.insert(insertionPoint, " SKIP " + offset + " TOP " + limit + " ");
            }
        } else {
            sql2.insert(insertionPoint, " TOP " + limit);
        }
        return sql2.toString();
    }

    public boolean isUseSkipTop() {
        return this.useSkipTop;
    }

    public TopLimitHandler setUseSkipTop(boolean useSkipTop) {
        this.useSkipTop = useSkipTop;
        return this;
    }
}

