/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.sqlscript;

import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlDelimiter;
import com.jn.sqlhelper.common.sql.sqlscript.PlainSqlStatementBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgreSQLSqlStatementBuilder
extends PlainSqlStatementBuilder {
    private static final PlainSqlDelimiter COPY_DELIMITER = new PlainSqlDelimiter("\\.", true);
    static final String DOLLAR_QUOTE_REGEX = "(\\$[A-Za-z0-9_]*\\$).*";
    private boolean firstLine = true;
    private boolean pgCopy;

    protected String extractAlternateOpenQuote(String token) {
        Matcher matcher = Pattern.compile(DOLLAR_QUOTE_REGEX).matcher(token);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected PlainSqlDelimiter changeDelimiterIfNecessary(String line, PlainSqlDelimiter delimiter) {
        if (this.firstLine) {
            this.firstLine = false;
            if (line.matches("COPY|COPY\\s.*")) {
                this.pgCopy = true;
                return COPY_DELIMITER;
            }
        }
        return this.pgCopy ? COPY_DELIMITER : delimiter;
    }

    public boolean isPgCopy() {
        return this.pgCopy;
    }
}

