/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.Objs;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.List;

public class DefaultDatabaseInfo
implements DatabaseInfo {
    private final String databaseInstance;
    private final String realUrl;
    private final String normalizedUrl;
    private final List<String> host;
    private final String multipleHost;
    private final String vendor;
    private final boolean parsingComplete;

    public DefaultDatabaseInfo(String vendor, String realUrl, String normalizedUrl, List<String> host, String databaseInstance) {
        this(vendor, realUrl, normalizedUrl, host, databaseInstance, true);
    }

    public DefaultDatabaseInfo(String vendor, String realUrl, String normalizedUrl, List<String> host, String databaseInstance, boolean parsingComplete) {
        this.vendor = (String)Objs.useValueIfEmpty((Object)vendor, (Object)"unknown");
        this.realUrl = realUrl;
        this.normalizedUrl = normalizedUrl;
        this.host = host;
        this.multipleHost = this.merge(host);
        this.databaseInstance = databaseInstance;
        this.parsingComplete = parsingComplete;
    }

    private String merge(List<String> host) {
        if (host.isEmpty()) {
            return "";
        }
        String single = host.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(single);
        for (int i = 1; i < host.size(); ++i) {
            sb.append(',');
            sb.append(host.get(i));
        }
        return sb.toString();
    }

    @Override
    public List<String> getHost() {
        return this.host;
    }

    @Override
    public String getMultipleHost() {
        return this.multipleHost;
    }

    @Override
    public String getDatabaseInstance() {
        return this.databaseInstance;
    }

    @Override
    public String getRealUrl() {
        return this.realUrl;
    }

    @Override
    public String getUrl() {
        return this.normalizedUrl;
    }

    @Override
    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDatabaseInfo{");
        sb.append("verdor=").append(this.vendor);
        sb.append(", databaseId='").append(this.databaseInstance).append('\'');
        sb.append(", realUrl='").append(this.realUrl).append('\'');
        sb.append(", normalizedUrl='").append(this.normalizedUrl).append('\'');
        sb.append(", host=").append(this.host);
        sb.append(", multipleHost='").append(this.multipleHost).append('\'');
        sb.append(", parsingComplete=").append(this.parsingComplete);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }
}

