/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.StringMaker;
import com.jn.sqlhelper.dialect.internal.urlparser.CommonUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.DefaultDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.oracle.Description;
import com.jn.sqlhelper.dialect.internal.urlparser.oracle.KeyValue;
import com.jn.sqlhelper.dialect.internal.urlparser.oracle.OracleNetConnectionDescriptorParser;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OracleUrlParser
extends CommonUrlParser {
    private static final String URL_PREFIX = "jdbc:oracle:";
    private static final List<String> URL_SCHEMAS = Arrays.asList("jdbc:oracle:");

    @Override
    public List<String> getUrlSchemas() {
        return URL_SCHEMAS;
    }

    @Override
    protected DatabaseInfo parse0(String jdbcUrl, String urlPrefix) {
        StringMaker maker = new StringMaker(jdbcUrl);
        maker.after(URL_PREFIX).after(":");
        String description = maker.after('@').value().trim();
        if (description.startsWith("(")) {
            return this.parseNetConnectionUrl(jdbcUrl);
        }
        return this.parseSimpleUrl(jdbcUrl, maker);
    }

    private DatabaseInfo parseNetConnectionUrl(String url) {
        OracleNetConnectionDescriptorParser parser = new OracleNetConnectionDescriptorParser(url);
        KeyValue keyValue = parser.parse();
        return this.createOracleDatabaseInfo(keyValue, url);
    }

    private DatabaseInfo createOracleDatabaseInfo(KeyValue keyValue, String url) {
        Description description = new Description(keyValue);
        List<String> jdbcHost = description.getJdbcHost();
        return new DefaultDatabaseInfo("oracle", url, url, jdbcHost, description.getDatabaseId());
    }

    private DefaultDatabaseInfo parseSimpleUrl(String url, StringMaker maker) {
        String host = maker.before(':').value();
        String port = maker.next().after(':').before(':', '/').value();
        String databaseId = maker.next().afterLast(':', '/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host + ":" + port);
        return new DefaultDatabaseInfo("oracle", url, url, hostList, databaseId);
    }
}

