/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.likeescaper;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import java.util.List;

public class BaseLikeEscaper
implements LikeEscaper {
    protected final List<Character> keyChars = Collects.asList((Object[])new Character[]{Character.valueOf('\''), Character.valueOf('_'), Character.valueOf('%')});
    protected char escapeChar = (char)48;

    public BaseLikeEscaper() {
    }

    public BaseLikeEscaper(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    @Override
    public List<Character> getLikeKeyChars() {
        return this.keyChars;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public String escape(String pattern) {
        final List<Character> specifiedChars = this.getLikeKeyChars();
        if (Emptys.isNotEmpty((Object)pattern)) {
            final StringBuilder builder = new StringBuilder(pattern.length() + 20);
            Collects.forEach((Object[])PrimitiveArrays.wrap((char[])pattern.toCharArray(), (boolean)true), (Consumer)new Consumer<Character>(){

                public void accept(Character c) {
                    if (specifiedChars.contains(c)) {
                        builder.append(BaseLikeEscaper.this.escapeLikeKeyChar(c.charValue()));
                    } else if (c.charValue() == BaseLikeEscaper.this.escapeChar) {
                        builder.append(BaseLikeEscaper.this.escapeChar).append(BaseLikeEscaper.this.escapeChar);
                    } else {
                        builder.append(c);
                    }
                }
            });
            return builder.toString();
        }
        return pattern;
    }

    protected String escapeLikeKeyChar(char c) {
        return this.escapeChar == '0' ? "" + c : "" + this.escapeChar + c;
    }

    @Override
    public String appendmentAfterLikeClause() {
        return " ESCAPE '" + this.escapeChar + "' ";
    }

    public String toString() {
        return "BaseLikeEscaper{keyChars=" + this.keyChars + ", escapeChar=" + this.escapeChar + '}';
    }
}

