/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.orderby;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.symbolmapper.NoopSymbolMapper;
import com.jn.sqlhelper.common.symbolmapper.SqlSymbolMapper;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.orderby.OrderByBuilder;
import com.jn.sqlhelper.dialect.orderby.OrderByItem;
import com.jn.sqlhelper.dialect.orderby.OrderByType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class SqlStyleOrderByBuilder
implements OrderByBuilder<String> {
    public static final SqlStyleOrderByBuilder DEFAULT = new SqlStyleOrderByBuilder();
    private final List<String> keywordsAfterOrderBy = new ArrayList<String>(Arrays.asList("limit", "offset", "PROCEDURE"));
    private SqlSymbolMapper sqlSymbolMapper = NoopSymbolMapper.DEFAULT;

    public SqlStyleOrderByBuilder addKeywords(List<String> keywords) {
        if (keywords != null) {
            for (String keyword : keywords) {
                this.addKeyword(keyword);
            }
        }
        return this;
    }

    public SqlStyleOrderByBuilder addKeyword(String keyword) {
        if (!Strings.isBlank((String)keyword)) {
            this.keywordsAfterOrderBy.add(keyword.toLowerCase());
        }
        return this;
    }

    public SqlStyleOrderByBuilder sqlSymbolMapper(SqlSymbolMapper symbolMapper) {
        if (symbolMapper != null) {
            this.sqlSymbolMapper = symbolMapper;
        }
        return this;
    }

    @Override
    public OrderBy build(String s) {
        if (Strings.isBlank((String)s)) {
            return OrderBy.EMPTY;
        }
        OrderBy orderBy = new OrderBy();
        String currentExpression = null;
        String currentOrderType = null;
        StringTokenizer tokenizer = new StringTokenizer(s, " \t\n\r\f,", true);
        while (tokenizer.hasMoreTokens()) {
            boolean isSqlSortSymbol;
            String token = tokenizer.nextToken();
            if (Strings.isBlank((String)token)) continue;
            String tmp = token.toLowerCase();
            boolean isSqlDelimiter = ",".equals(tmp);
            boolean bl = isSqlSortSymbol = "asc".equals(tmp) || "desc".equals(tmp);
            if (!isSqlDelimiter && !isSqlSortSymbol) {
                if (this.keywordsAfterOrderBy.contains(tmp)) break;
                if (currentExpression != null) {
                    if ("update".equals(tmp) && "for".equalsIgnoreCase(currentExpression)) {
                        currentExpression = null;
                        currentOrderType = null;
                        break;
                    }
                    if ("outfile".equals(tmp) && "into".equalsIgnoreCase(currentExpression)) {
                        currentExpression = null;
                        currentOrderType = null;
                        break;
                    }
                }
                currentExpression = token;
                continue;
            }
            if (isSqlSortSymbol) {
                currentOrderType = token;
            }
            if (currentExpression == null) {
                currentOrderType = null;
                continue;
            }
            orderBy.add(new OrderByItem((String)this.sqlSymbolMapper.apply((Object)currentExpression), OrderByType.fromString(currentOrderType)));
            currentExpression = null;
            currentOrderType = null;
        }
        if (currentExpression != null) {
            orderBy.add(new OrderByItem((String)this.sqlSymbolMapper.apply(currentExpression), OrderByType.fromString(currentOrderType)));
        }
        return orderBy;
    }
}

