/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.pagination;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.NonDistinctTreeSet;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.comparator.ComparableComparator;
import com.jn.langx.util.comparator.ParallelingComparator;
import com.jn.langx.util.comparator.ReverseComparator;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.FieldComparator;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.orderby.OrderByItem;
import com.jn.sqlhelper.dialect.orderby.OrderByType;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;
import com.jn.sqlhelper.dialect.pagination.PagingResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPaginations {
    private static final Logger logger = LoggerFactory.getLogger(MemoryPaginations.class);

    public static <C, E> List<E> paging(Collection<E> list, PagingRequest<C, E> pagingRequest, Predicate<E> ... filters) {
        List<E> sorted;
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(pagingRequest);
        Predicate filter = Emptys.isNotEmpty(filters) ? Functions.allPredicate(filters) : null;
        List<E> filtered = Collects.asList(filter != null ? Collects.filter(list, (Predicate)filter) : list);
        PagingResult result = new PagingResult();
        pagingRequest.setResult(result);
        result.setPageNo(pagingRequest.getPageNo());
        result.setPageSize(pagingRequest.getPageSize());
        result.setTotal(filtered.size());
        if (list.isEmpty() || pagingRequest.isEmptyRequest()) {
            ArrayList rs = new ArrayList();
            result.setItems(rs);
            return rs;
        }
        List<E> list2 = sorted = pagingRequest.needOrderBy() ? MemoryPaginations.doSort(filtered, pagingRequest.getOrderBy()) : filtered;
        if (pagingRequest.isGetAllRequest()) {
            result.setItems(sorted);
            return sorted;
        }
        if (pagingRequest.isGetAllFromNonZeroOffsetRequest()) {
            int pageSize = 10;
            int offset = (pagingRequest.getPageNo() - 1) * pageSize;
            List rs = Collects.emptyArrayList();
            Pipeline.of(sorted).skip(offset).addTo((Collection)rs);
            result.setItems(rs);
            return rs;
        }
        int offset = (pagingRequest.getPageNo() - 1) * pagingRequest.getPageSize();
        int limit = pagingRequest.getPageSize();
        List rs = Collects.emptyArrayList();
        Pipeline.of(sorted).skip(offset).limit(limit).addTo((Collection)rs);
        result.setItems(rs);
        return rs;
    }

    private static <E> List<E> doSort(Collection<E> collection, OrderBy orderBy) {
        if (collection.isEmpty() || !orderBy.isValid()) {
            return Collects.asList(collection);
        }
        List list = Collects.asList(collection);
        Class<?> modelClass = list.get(0).getClass();
        ParallelingComparator parallelingComparator = new ParallelingComparator();
        int i = 0;
        for (OrderByItem orderByItem : orderBy) {
            String fieldName = orderByItem.getExpression();
            Field field = Reflects.getDeclaredField(modelClass, (String)fieldName);
            if (field != null) {
                Class<?> fieldClass;
                Comparator comparator = orderByItem.getComparator();
                if (comparator == null && Comparable.class.isAssignableFrom(Primitives.wrap(fieldClass = field.getType()))) {
                    comparator = new ComparableComparator();
                }
                if (comparator == null) continue;
                comparator = new FieldComparator(field, comparator);
                if (orderByItem.getType() == OrderByType.DESC) {
                    comparator = new ReverseComparator(comparator);
                }
                parallelingComparator.addComparator(comparator);
                ++i;
                continue;
            }
            logger.warn("can't find a field [{}] in class [{}]", (Object)fieldName, (Object)Reflects.getFQNClassName(modelClass));
        }
        if (i > 0) {
            NonDistinctTreeSet rs = new NonDistinctTreeSet((Comparator)parallelingComparator);
            rs.addAll(list);
            return Collects.asList((Iterable)rs);
        }
        return list;
    }
}

