/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.pagination;

import com.jn.sqlhelper.dialect.conf.Settings;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import com.jn.sqlhelper.dialect.pagination.RowSelectionBuilder;

public class PagingRequestBasedRowSelectionBuilder
implements RowSelectionBuilder<PagingRequest> {
    private int defaultPageSize = Settings.getInstance().getPageSize();

    @Override
    public RowSelection build(PagingRequest request) throws IllegalArgumentException {
        if (request.isValidRequest()) {
            RowSelection rowSelection = new RowSelection();
            rowSelection.setFetchSize(request.getFetchSize());
            rowSelection.setTimeout(request.getTimeout());
            int pageNo = request.getPageNo();
            long offset = 0L;
            int limit = request.getPageSize();
            if (request.isGetAllFromNonZeroOffsetRequest()) {
                offset = (pageNo - 1) * this.getDefaultPageSize();
                limit = Integer.MAX_VALUE;
            } else {
                offset = pageNo > 0 ? (long)((pageNo - 1) * request.getPageSize()) : 0L;
            }
            rowSelection.setLimit(limit);
            if (offset - 1L + (long)rowSelection.getLimit().intValue() > Integer.MAX_VALUE) {
                rowSelection.setFetchSize(Integer.MAX_VALUE - Long.valueOf(offset).intValue());
            }
            rowSelection.setOffset(offset);
            rowSelection.setMaxRows(request.getMaxRows());
            return rowSelection;
        }
        throw new IllegalArgumentException("PagingRequest is illegal");
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }
}

