/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.parameter;

import com.jn.sqlhelper.dialect.pagination.PagedPreparedParameterSetter;
import com.jn.sqlhelper.dialect.parameter.ArrayBasedQueryParameters;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ArrayBasedParameterSetter
implements PagedPreparedParameterSetter<ArrayBasedQueryParameters> {
    @Override
    public int setOriginalParameters(PreparedStatement statement, ArrayBasedQueryParameters queryParameters, int startIndex) throws SQLException {
        if (queryParameters.getParameterValuesSize() > 0) {
            for (Object value : (Object[])queryParameters.getParameterValues()) {
                statement.setObject(startIndex, value);
                ++startIndex;
            }
        }
        return queryParameters.getParameterValuesSize();
    }

    @Override
    public int setBeforeSubqueryParameters(PreparedStatement statement, ArrayBasedQueryParameters queryParameters, int startIndex) throws SQLException {
        if (queryParameters.getBeforeSubqueryParameterCount() > 0) {
            for (Object value : (Object[])queryParameters.getBeforeSubqueryParameterValues()) {
                statement.setObject(startIndex, value);
                ++startIndex;
            }
        }
        return queryParameters.getBeforeSubqueryParameterCount();
    }

    @Override
    public int setSubqueryParameters(PreparedStatement statement, ArrayBasedQueryParameters parameters, int startIndex) throws SQLException {
        if (((Object[])parameters.getSubqueryParameterValues()).length > 0) {
            for (Object value : (Object[])parameters.getSubqueryParameterValues()) {
                statement.setObject(startIndex, value);
                ++startIndex;
            }
        }
        return ((Object[])parameters.getSubqueryParameterValues()).length;
    }

    @Override
    public int setAfterSubqueryParameters(PreparedStatement statement, ArrayBasedQueryParameters queryParameters, int startIndex) throws SQLException {
        if (queryParameters.getAfterSubqueryParameterCount() > 0) {
            for (Object value : (Object[])queryParameters.getAfterSubqueryParameterValues()) {
                statement.setObject(startIndex, value);
                ++startIndex;
            }
        }
        return queryParameters.getAfterSubqueryParameterCount();
    }
}

